package com.biz.crm.cps.business.reward.redpacket.local.service.observer;

import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityVo;
import com.biz.crm.cps.business.capital.sdk.common.enums.BusinessTypeEnum;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketDetailVo;
import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import com.biz.crm.cps.business.reward.sdk.common.enums.RewardRelateTypeEnum;
import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardServiceObserver;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategy;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategyHolder;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxDeductionAmountDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseCapitalAccountVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 协议金额实现
 *
 * @author yangfan
 */
@Component("RedPacketRewardServiceObserverImpl")
@Slf4j
public class RedPacketRewardServiceObserverImpl implements RewardServiceObserver {

  @Autowired
  @Qualifier("RedpacketRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;

  @Autowired private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private RewardComputeStrategyHolder rewardComputeStrategyHolder;

  @Autowired private RedPacketDetailService redPacketDetailService;

  @Autowired private TaxRaiseCapitalAccountVoService taxRaiseCapitalAccountVoService;

  @Transactional
  @Override
  public void onCreate(RewardConditionDto item) {
    Validate.notNull(item, "奖励条件信息不能为空！");
    Validate.notBlank(item.getRewardMethodFlag(), "奖励方式不能为空！");
    Validate.notBlank(item.getAwardConditionFlag(), "奖励计算方式不能为空！");
    // 1根据奖励方式判断是否计算
    if (StringUtil.equals(item.getRewardMethodFlag(), rewardMountRegister.getKey())) {
      RedPacketDetailVo redPacketDetailVo =
          this.nebulaToolkitService.copyObjectByWhiteList(
              item, RedPacketDetailVo.class, HashSet.class, ArrayList.class);
      // 2根据计算方式选择策略
      Validate.notNull(rewardComputeStrategyHolder, "奖励计算策略控制器不能为空！");
      RewardComputeStrategy computeStrategy =
          this.rewardComputeStrategyHolder.getStrategy(item.getAwardConditionFlag());
      Validate.notNull(computeStrategy, "红包奖励计算方式不能为空！");
      ComputeCashVo computeCashVo = computeStrategy.calculate(item);
      BigDecimal amount =
          computeCashVo.getRecordCash() == null ? BigDecimal.ZERO : computeCashVo.getRecordCash();
      redPacketDetailVo.setAmount(amount);
      // 3根据条件计算结果，保存流水
      redPacketDetailVo.setParticipatorCode(item.getAdditionalParticipatorCode());
      redPacketDetailVo.setParticipatorName(item.getAdditionalParticipatorName());
      redPacketDetailVo.setParticipatorType(item.getAdditionalParticipatorFlag());
      redPacketDetailVo.setOrgCode(item.getOrgCode());
      redPacketDetailVo.setOrgName(item.getOrgName());
      redPacketDetailVo.setChannel(item.getChannel());
      redPacketDetailVo.setPhone(item.getPhone());
      // redPacketDetailVo对象转RedPacketDetailDto对象
      RedPacketDetailDto redPacketDetailDto =
          this.nebulaToolkitService.copyObjectByWhiteList(
              redPacketDetailVo, RedPacketDetailDto.class, HashSet.class, ArrayList.class);
      redPacketDetailDto.setType(IncomeStatusEnum.ADD.getDictCode());
      redPacketDetailDto.setRelateType(StringUtils.EMPTY);
      redPacketDetailDto.setRelateCode(StringUtils.EMPTY);
      if (org.apache.commons.lang.StringUtils.isNotBlank(item.getAgreementCode())) {
        redPacketDetailDto.setRelateType(RewardRelateTypeEnum.AGREEMENT.getDictCode());
        redPacketDetailDto.setRelateCode(item.getAgreementCode());
      } else if (org.apache.commons.lang.StringUtils.isNotBlank(item.getActCode())) {
        redPacketDetailDto.setRelateType(RewardRelateTypeEnum.SCAN_ACTIVITY.getDictCode());
        redPacketDetailDto.setRelateCode(item.getActCode());
        this.deductAmount(redPacketDetailDto, item.getAccountCode());
      }
      // 4判断是否有传递奖励
      this.redPacketDetailService.create(redPacketDetailDto);
    }
  }

  /**
   * 扫码活动红包发放扣减账户可用余额
   *
   * @param dto
   * @param accountCode 红包发放账户编码
   */
  private void deductAmount(RedPacketDetailDto dto, String accountCode) {
    // 扫码活动红包发放扣减账户可用余额
    if (Objects.isNull(dto) || StringUtils.isBlank(accountCode)) {
      log.error("{}-对应的扫码活动未配置红包发放账户信息", accountCode);
      return;
    }
    TaxDeductionAmountDto taxDeductionAmountDto = new TaxDeductionAmountDto();
    taxDeductionAmountDto.setMerchantUserAccount(accountCode);
    taxDeductionAmountDto.setChangeAmount(dto.getAmount());
    taxDeductionAmountDto.setBusinessType(BusinessTypeEnum.RED_PACKET.getDictCode());
    taxDeductionAmountDto.setRelevanceCode(dto.getRecordCode());
    try {
      log.info("红包放发【{}】", taxDeductionAmountDto);
      this.taxRaiseCapitalAccountVoService.deductAmountByDeductionAmountDto(taxDeductionAmountDto);
    } catch (Exception e) {
      log.error("红包放发失败[{}]", Throwables.getStackTraceAsString(e));
      Validate.isTrue(false, "红包发放失败");
    }
  }
}
