package com.biz.crm.cps.business.reward.redpacket.local.service.observer;

import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardTypeStatisticsServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 奖励统计观察者接口实现
 * @date 2021/8/24 下午7:23
 */
@Component("RedPacketRewardTypeStatisticsServiceObserverImpl")
public class RedPacketRewardTypeStatisticsServiceObserverImpl implements RewardTypeStatisticsServiceObserver {

  @Autowired
  @Qualifier("RedpacketRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;
  @Autowired
  private RedPacketDetailService redPacketDetailService;

  @Override
  public RewardTypeStatisticsVo onRequestRewardTypeStatisticsVo(String participatorCode, List<String> recordCodes) {
    if(StringUtils.isBlank(participatorCode)|| CollectionUtils.isEmpty(recordCodes)){
      return null;
    }
    recordCodes = recordCodes.stream().filter(item->StringUtils.isNotBlank(item)).collect(Collectors.toList());
    RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
    vo.setName(this.rewardMountRegister.getName());
    vo.setFlag(this.rewardMountRegister.getFlag());
    vo.setKey(this.rewardMountRegister.getKey());
    BigDecimal total = this.redPacketDetailService.sumByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
    total = total == null ? BigDecimal.ZERO : total;
    vo.setAmount(total.setScale(2, RoundingMode.HALF_UP));
    return vo;
  }

  @Override
  public RewardTypeStatisticsVo onRequestRewardTypeStatisticsVo(String tenantCode, String triggerAction) {
    if(StringUtils.isBlank(tenantCode)||StringUtils.isBlank(triggerAction)){
      return null;
    }
    RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
    vo.setName(this.rewardMountRegister.getName());
    vo.setFlag(this.rewardMountRegister.getFlag());
    vo.setKey(this.rewardMountRegister.getKey());
    BigDecimal total = this.redPacketDetailService.sumByTenantCodeAndTriggerAction(tenantCode, triggerAction);
    total = total == null ? BigDecimal.ZERO : total;
    vo.setAmount(total.setScale(2, RoundingMode.HALF_UP));
    return vo;
  }
}
