/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.repository;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.cps.business.reward.redpacket.local.mapper.RedPacketParticipatorRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.sdk.vo.ParticipatorRewardStatisticsVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedPacketParticipatorRewardStatisticsVoRepository {
    @Autowired
    private RedPacketParticipatorRewardStatisticsVoMapper redPacketParticipatorRewardStatisticsVoMapper;

    public List<ParticipatorRewardStatisticsVo> findByParticipatorCodes(List<String> participatorCodes) {
        List<ParticipatorRewardStatisticsVo> list = this.redPacketParticipatorRewardStatisticsVoMapper.findByParticipatorCodes(participatorCodes);
        if (!CollectionUtils.isEmpty(list)) {
            List<ParticipatorRewardStatisticsVo> todayAmount = this.redPacketParticipatorRewardStatisticsVoMapper.findTodayAmountByParticipatorCodes(participatorCodes, DateUtil.today());
            if (CollectionUtils.isEmpty(todayAmount)) {
                return list;
            }
            Map<String, BigDecimal> map = todayAmount.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getParticipatorCode()) && Objects.nonNull(a.getTodayAmount())).collect(Collectors.toMap(ParticipatorRewardStatisticsVo::getParticipatorCode, ParticipatorRewardStatisticsVo::getTodayAmount, (a, b) -> a));
            for (ParticipatorRewardStatisticsVo item : list) {
                item.setTodayAmount(map.getOrDefault(item.getParticipatorCode(), BigDecimal.ZERO));
            }
        }
        return list;
    }
}

