/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.KeepBooksRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepBooksServiceImpl
implements KeepBooksService {
    @Autowired
    private KeepBooksRepository keepBooksRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public void updateTop1SubBalance(BigDecimal amount) {
        KeepBooksEntity booksEntity = this.findByTenantCode(TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)booksEntity), (String)"\u8d26\u6237\u8bb0\u5f55\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        long count = this.keepBooksRepository.subtractBalance(booksEntity.getId(), amount, this.loginUserService.getLoginAccountName());
        Validate.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u6263\u51cf\u4f59\u989d\u5931\u8d25\uff01", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public KeepBooksEntity create(KeepBooksDto keepBooksDto) {
        this.validateCreate(keepBooksDto);
        KeepBooksEntity old = this.findByTenantCode(TenantUtils.getTenantCode());
        if (old != null) {
            long count = this.keepBooksRepository.addBalance(old.getId(), keepBooksDto.getAmount(), this.loginUserService.getLoginAccountName());
            Validate.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u5931\u8d25\uff01", (Object[])new Object[0]);
            BigDecimal balance = this.findBalanceById(old.getId());
            old.setBalance(balance);
            return old;
        }
        KeepBooksEntity create = new KeepBooksEntity();
        create.setTenantCode(TenantUtils.getTenantCode());
        create.setRemark(keepBooksDto.getRemark());
        create.setBalance(keepBooksDto.getAmount());
        create.setCreateAccount(this.loginUserService.getLoginAccountName());
        create.setCreateTime(new Date());
        this.keepBooksRepository.save((Object)create);
        return create;
    }

    @Override
    public KeepBooksEntity findByTenantCode(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        return this.keepBooksRepository.findByTenantCode(tenantCode);
    }

    @Override
    public BigDecimal findBalanceById(String id) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        return this.keepBooksRepository.findBalanceById(id);
    }

    private void validateCreate(KeepBooksDto keepBooksDto) {
        Validate.notNull((Object)keepBooksDto, (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)keepBooksDto.getAmount(), (String)"\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keepBooksDto.getRemark(), (String)"\u4e0a\u8d26\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

