/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketConfigEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.MaxAmountLimitRepository;
import com.biz.crm.cps.business.reward.redpacket.local.repository.MaxCountLimitRepository;
import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketConfigRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.MaxAmountLimitService;
import com.biz.crm.cps.business.reward.redpacket.local.service.MaxCountLimitService;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketConfigService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RedPacketConfigServiceImpl
implements RedPacketConfigService {
    @Autowired
    private RedPacketConfigRepository redPacketConfigRepository;
    @Autowired
    private MaxAmountLimitService maxAmountLimitService;
    @Autowired
    private MaxCountLimitService maxCountLimitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private MaxAmountLimitRepository maxAmountLimitRepository;
    @Autowired
    private MaxCountLimitRepository maxCountLimitRepository;

    @Override
    @Transactional
    public void create(List<RedPacketConfigEntity> configs) {
        this.validate(configs);
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Date date = new Date();
        for (RedPacketConfigEntity config : configs) {
            if (StringUtils.isBlank((CharSequence)config.getId())) {
                config.setTenantCode(TenantUtils.getTenantCode());
                config.setCreateAccount(loginAccountName);
                config.setCreateTime(date);
                config.setModifyAccount(loginAccountName);
                config.setModifyTime(date);
                continue;
            }
            RedPacketConfigEntity old = this.redPacketConfigRepository.findById(config.getId());
            Validate.notNull((Object)((Object)old), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            config.setTenantCode(old.getTenantCode());
            config.setCreateTime(old.getCreateTime());
            config.setCreateAccount(old.getCreateAccount());
            config.setModifyAccount(loginAccountName);
            config.setModifyTime(date);
        }
        this.redPacketConfigRepository.saveOrUpdateBatch(configs);
        for (RedPacketConfigEntity config : configs) {
            String configId = config.getId();
            if (config.getIsMaxCountLimit() == 1) {
                this.maxCountLimitService.create(config.getCountLimitDetails(), configId);
            } else {
                this.maxCountLimitRepository.deleteByRedPacketConfigId(configId);
            }
            if (config.getIsMaxAmountLimit() == 1) {
                this.maxAmountLimitService.create(config.getAmountLimitDetails(), configId);
                continue;
            }
            this.maxAmountLimitRepository.deleteByRedPacketConfigId(configId);
        }
    }

    private void validate(List<RedPacketConfigEntity> configs) {
        Validate.notEmpty(configs, (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        for (RedPacketConfigEntity config : configs) {
            Validate.notNull((Object)config.getIsAmountLimit(), (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u7ea2\u5305\u63d0\u73b0\u95e8\u69db\u91d1\u989d\u9650\u5236\u5fc5\u987b\u9009\u62e9\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            if (config.getIsAmountLimit() == 0) {
                Validate.isTrue((config.getAmountLimit() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u7ea2\u5305\u63d0\u73b0\u95e8\u69db\u91d1\u989d\u9009\u62e9\u4e0d\u9650\u5236\u540e\u4e0d\u5141\u8bb8\u586b\u5199\u9650\u5236\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            } else {
                Validate.isTrue((config.getAmountLimit() != null ? 1 : 0) != 0, (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u7ea2\u5305\u63d0\u73b0\u95e8\u69db\u91d1\u989d\u9009\u62e9\u9650\u5236\u540e\u5fc5\u987b\u586b\u5199\u9650\u5236\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            }
            Validate.notNull((Object)config.getIsOneCountLimit(), (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u5355\u6b21\u7ea2\u5305\u63d0\u73b0\u91d1\u989d\u9650\u5236\u5fc5\u987b\u9009\u62e9\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            if (config.getIsOneCountLimit() == 0) {
                Validate.isTrue((config.getOneAmountLimit() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u5355\u6b21\u7ea2\u5305\u63d0\u73b0\u91d1\u989d\u9009\u62e9\u4e0d\u9650\u5236\u540e\u4e0d\u5141\u8bb8\u586b\u5199\u9650\u5236\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            } else {
                Validate.isTrue((config.getOneAmountLimit() != null ? 1 : 0) != 0, (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u5355\u6b21\u7ea2\u5305\u63d0\u73b0\u91d1\u989d\u9009\u62e9\u9650\u5236\u540e\u5fc5\u987b\u586b\u5199\u9650\u5236\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            }
            Validate.notNull((Object)config.getIsMaxAmountLimit(), (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u7ea2\u5305\u63d0\u73b0\u91d1\u989d\u4e0a\u9650\u9650\u5236\u5fc5\u987b\u9009\u62e9\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            if (config.getIsMaxAmountLimit() == 0) {
                Validate.isTrue((boolean)CollectionUtils.isEmpty(config.getAmountLimitDetails()), (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u7ea2\u5305\u63d0\u73b0\u91d1\u989d\u4e0a\u9650\u8bbe\u7f6e\u9009\u62e9\u4e0d\u9650\u5236\u540e\u4e0d\u5141\u8bb8\u586b\u5199\u9650\u5236\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            } else {
                Validate.isTrue((!CollectionUtils.isEmpty(config.getAmountLimitDetails()) ? 1 : 0) != 0, (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u7ea2\u5305\u63d0\u73b0\u91d1\u989d\u4e0a\u9650\u8bbe\u7f6e\u9009\u62e9\u9650\u5236\u540e\u5fc5\u987b\u586b\u5199\u9650\u5236\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            }
            Validate.notNull((Object)config.getIsMaxAmountLimit(), (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u7ea2\u5305\u63d0\u73b0\u6b21\u6570\u4e0a\u9650\u9650\u5236\u5fc5\u987b\u9009\u62e9\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            if (config.getIsMaxCountLimit() == 0) {
                Validate.isTrue((boolean)CollectionUtils.isEmpty(config.getCountLimitDetails()), (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u7ea2\u5305\u63d0\u73b0\u6b21\u6570\u4e0a\u9650\u8bbe\u7f6e\u9009\u62e9\u4e0d\u9650\u5236\u540e\u4e0d\u5141\u8bb8\u586b\u5199\u9650\u5236\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                continue;
            }
            Validate.isTrue((!CollectionUtils.isEmpty(config.getCountLimitDetails()) ? 1 : 0) != 0, (String)"\u521b\u5efa\u7ea2\u5305\u6743\u76ca\u914d\u7f6e\u65f6\uff0c\u7ea2\u5305\u63d0\u73b0\u6b21\u6570\u4e0a\u9650\u8bbe\u7f6e\u9009\u62e9\u9650\u5236\u540e\u5fc5\u987b\u586b\u5199\u9650\u5236\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        }
    }

    @Override
    public List<RedPacketConfigEntity> findAll() {
        return this.redPacketConfigRepository.findAll();
    }
}

