/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorVo;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketDetailVoRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketDetailVoService;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RedPacketDetailVoServiceImpl
implements RedPacketDetailVoService {
    @Autowired
    private RedPacketDetailService redPacketDetailService;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private RedPacketDetailVoRepository redPacketDetailVoRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ConsumerVoService consumerVoService;
    @Autowired
    private ParticipatorVoService participatorVoService;
    @Autowired
    private ParticipatorTagVoService participatorTagVoService;

    public Page<RedPacketDetailVo> findByParticipatorCodeAndCreateTimeAndType(String participatorCode, String yearAndMonth, String type, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)participatorCode)) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        RedPacketDetailDto queryDto = new RedPacketDetailDto();
        queryDto.setParticipatorCode(participatorCode);
        queryDto.setYearAndMonth(yearAndMonth);
        queryDto.setType(type);
        queryDto.setTenantCode(TenantUtils.getTenantCode());
        Page<RedPacketDetailEntity> result = this.redPacketDetailService.findByConditions(pageable, queryDto);
        if (Objects.isNull(result)) {
            return new Page();
        }
        List details = result.getRecords();
        ArrayList<RedPacketDetailVo> vos = new ArrayList<RedPacketDetailVo>();
        for (RedPacketDetailEntity entity : details) {
            RedPacketDetailVo vo = new RedPacketDetailVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            LoginUserAgreementDto dto = new LoginUserAgreementDto();
            dto.setTerminalCode(participatorCode);
            dto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{entity.getTemplateCode()}));
            List agreements = this.agreementVoService.findByConditions(dto);
            if (CollectionUtils.isNotEmpty((Collection)agreements)) {
                vo.setTemplateCode(((AgreementVo)agreements.get(0)).getTemplateCode());
                vo.setTemplateName(((AgreementVo)agreements.get(0)).getBelongTemplate());
            }
            vos.add(vo);
        }
        Page page = new Page();
        page.setCurrent(result.getCurrent());
        page.setSize(result.getSize());
        page.setTotal(result.getTotal());
        page.setRecords(vos);
        return page;
    }

    public Page<RedPacketDetailVo> findByConditions(Pageable pageable, RedPacketDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new RedPacketDetailDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        try {
            String endCreateTime;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String startCreateTime = dto.getStartCreateTime();
            if (StringUtils.isNotBlank((CharSequence)startCreateTime)) {
                dto.setStartCreateTime(DateFormatUtils.format((Date)simpleDateFormat.parse(startCreateTime), (String)"yyyy-MM-dd 00:00:00"));
            }
            if (StringUtils.isNotBlank((CharSequence)(endCreateTime = dto.getEndCreateTime()))) {
                dto.setEndCreateTime(DateFormatUtils.format((Date)simpleDateFormat.parse(endCreateTime), (String)"yyyy-MM-dd 23:59:59"));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (dto.getParticipatorType().equals(ParticipatorTypeEnum.CONSUMER.getDictCode())) {
            Page<RedPacketDetailVo> consumerByConditions = this.redPacketDetailVoRepository.findConsumerByConditions(pageable, dto);
            return consumerByConditions;
        }
        if (dto.getParticipatorType().equals(ParticipatorTypeEnum.TERMINAL.getDictCode())) {
            Page<RedPacketDetailVo> terminalByConditions = this.redPacketDetailVoRepository.findTerminalByConditions(pageable, dto);
            this.buildRedPacketDetailVo(terminalByConditions);
            return terminalByConditions;
        }
        if (dto.getParticipatorType().equals(ParticipatorTypeEnum.DEALER.getDictCode())) {
            Page<RedPacketDetailVo> dealerByConditions = this.redPacketDetailVoRepository.findDealerByConditions(pageable, dto);
            this.buildRedPacketDetailVo(dealerByConditions);
            return dealerByConditions;
        }
        Page<RedPacketDetailVo> conditions = this.redPacketDetailVoRepository.findByConditions(pageable, dto);
        this.buildRedPacketDetailVo(conditions);
        return conditions;
    }

    @Transactional
    public RedPacketDetailVo create(RedPacketDetailDto dto) {
        dto.setParticipatorCode(((LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class)).getConsumerCode());
        dto.setParticipatorName(((LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class)).getConsumerName());
        ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)((LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class)).getUsertype());
        dto.setParticipatorType(participatorTypeEnum.getDictCode());
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTriggerAction(), (String)"\u89e6\u53d1\u52a8\u4f5c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParticipatorType(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAmount(), (String)"\u7ea2\u5305\u53d8\u52a8\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ParticipatorTypeEnum.CONSUMER.getDictCode().equals(dto.getParticipatorType())) {
            ConsumerVo consumerCode = this.consumerVoService.findByExternalId(dto.getParticipatorCode());
            Validate.notNull((Object)consumerCode, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005", (Object[])new Object[0]);
        } else {
            List list = this.participatorVoService.findByParticipatorTypeAndParticipatorCode(dto.getParticipatorType(), dto.getParticipatorCode());
            Validate.notEmpty((Collection)list, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005", (Object[])new Object[0]);
            ParticipatorVo participatorVo = list.stream().filter(item -> Objects.equals(item.getParticipatorType(), dto.getParticipatorType())).findFirst().orElse(null);
            Validate.notNull((Object)participatorVo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005\uff01", (Object[])new Object[0]);
            dto.setOrgCode(participatorVo.getOrgCode());
            dto.setOrgName(participatorVo.getOrgName());
            dto.setChannel(participatorVo.getChannel());
            dto.setPhone(participatorVo.getPhone());
            dto.setParticipatorName(participatorVo.getParticipatorName());
        }
        RedPacketDetailEntity redPacketDetailEntity = this.redPacketDetailService.create(dto);
        Validate.notNull((Object)((Object)redPacketDetailEntity), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u8fd4\u56de\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return (RedPacketDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPacketDetailEntity, RedPacketDetailVo.class, null, null, new String[0]);
    }

    private void buildRedPacketDetailVo(Page<RedPacketDetailVo> packetDetailVoPage) {
        if (packetDetailVoPage == null) {
            return;
        }
        List records = packetDetailVoPage.getRecords();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)records)) {
            return;
        }
        List codeList = records.stream().map(redPacketDetailVo -> redPacketDetailVo.getParticipatorCode()).collect(Collectors.toList());
        Map<Object, Object> participatorTagMap = new HashMap();
        List participatorTagList = this.participatorTagVoService.findByParticipatorCodes(codeList);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)participatorTagList)) {
            participatorTagMap = participatorTagList.stream().collect(Collectors.groupingBy(ParticipatorTagVo::getParticipatorCode));
        }
        for (RedPacketDetailVo entity : records) {
            List tags = (List)participatorTagMap.get(entity.getParticipatorCode());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)tags)) continue;
            String participatorTag = tags.stream().map(tag -> tag.getTagDescription()).collect(Collectors.joining(";"));
            entity.setTags(participatorTag);
        }
    }
}

