/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.redpacket.local.config.CashProperties;
import com.biz.crm.cps.business.reward.redpacket.local.config.RedPacketProperties;
import com.biz.crm.cps.business.reward.redpacket.local.entity.MaxAmountLimitEntity;
import com.biz.crm.cps.business.reward.redpacket.local.entity.MaxCountLimitEntity;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketConfigEntity;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketConfigService;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketRewardCashProcessVoService;
import com.biz.crm.cps.business.reward.sdk.dto.RewardCashConditionDto;
import com.biz.crm.cps.business.reward.sdk.event.RequestCashListener;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardCashObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashProcessVo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RedPacketRewardCashProcessVoServiceImpl")
public class RedPacketRewardCashProcessVoServiceImpl
implements RedPacketRewardCashProcessVoService {
    private static final String DAY = "day";
    private static final String MONTH = "month";
    @Autowired(required=false)
    private List<RewardCashObserver> rewardCashObserverList;
    @Autowired(required=false)
    private RedPacketProperties redPacketProperties;
    @Autowired
    private RedPacketService redPacketService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private RedPacketConfigService redPacketConfigService;
    @Autowired
    private RequestCashListener requestCashListener;

    public RewardCashProcessVo findByParticipator(RewardCashConditionDto conditionDto) {
        if (CollectionUtils.isEmpty(this.rewardCashObserverList) || Objects.isNull(conditionDto)) {
            return null;
        }
        Iterator<RewardCashObserver> iterator = this.rewardCashObserverList.iterator();
        if (iterator.hasNext()) {
            RewardCashObserver rewardCashObserver = iterator.next();
            this.buildCashType(conditionDto);
            RewardCashProcessVo cashProcessVo = rewardCashObserver.onRequestCashProcess(conditionDto);
            return cashProcessVo;
        }
        return null;
    }

    public RewardCashProcessVo findByCurrentUser() {
        LoginUserDetailsForCPS userDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)userDetails.getUsertype());
        RewardCashConditionDto conditionDto = new RewardCashConditionDto();
        conditionDto.setParticipatorCode(userDetails.getConsumerCode());
        conditionDto.setParticipatorName(userDetails.getConsumerName());
        conditionDto.setParticipatorFlag(participatorTypeEnum.getDictCode());
        conditionDto.setPayeeCode(userDetails.getAccount());
        conditionDto.setPayeeName(userDetails.getUsername());
        return this.findByParticipator(conditionDto);
    }

    public void validate(RewardCashConditionDto conditionDto) {
        Validate.notNull((Object)conditionDto, (String)"\u5151\u4ed8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal amount = conditionDto.getAmount();
        String participatorCode = conditionDto.getParticipatorCode();
        String participatorName = conditionDto.getParticipatorName();
        String participatorType = conditionDto.getParticipatorFlag();
        Validate.notNull((Object)amount, (String)"\u51cf\u5c11\u4f59\u989d\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((amount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u51cf\u5c11\u4f59\u989d\u65f6\uff0c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)participatorType, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)participatorName, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.cashValidate(conditionDto);
        RewardCashProcessVo rewardCashProcessVo = this.findByParticipator(conditionDto);
        Validate.notNull((Object)rewardCashProcessVo, (String)"\u3010%s\u3011\uff1a\u7f3a\u5c11\u5151\u73b0\u914d\u7f6e", (Object[])new Object[]{participatorName});
        Validate.isTrue((!rewardCashProcessVo.isNeedSign() ? 1 : 0) != 0, (String)"\u3010%s\u3011\uff1a\u5151\u73b0\u9700\u8981\u7b7e\u7f72\u670d\u52a1\u5408\u540c", (Object[])new Object[]{participatorName});
        Validate.isTrue((!rewardCashProcessVo.isNeedVerify() ? 1 : 0) != 0, (String)"\u3010%s\u3011\uff1a\u5151\u73b0\u9700\u8981\u5b9e\u540d\u8ba4\u8bc1", (Object[])new Object[]{participatorName});
        RedPacketEntity redPacket = this.redPacketService.findByParticipatorCode(participatorCode);
        Validate.notNull((Object)((Object)redPacket), (String)"\u3010%s\u3011\uff1a\u8fd8\u672a\u83b7\u5f97\u7ea2\u5305", (Object[])new Object[]{participatorName});
        BigDecimal balance = redPacket.getBalance() == null ? BigDecimal.ZERO : redPacket.getBalance();
        Validate.isTrue((balance.compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u63d0\u73b0\u91d1\u989d\u5927\u4e8e\u4f59\u989d", (Object[])new Object[0]);
    }

    public void buildCashType(RewardCashConditionDto conditionDto) {
        Validate.notNull((Object)conditionDto, (String)"\u5151\u4ed8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CashProperties> cashProperties = this.redPacketProperties.getCashs();
        Validate.notEmpty(cashProperties, (String)"\u7cfb\u7edf\u7f3a\u5c11\u7ea2\u5305\u63d0\u73b0\u914d\u7f6e", (Object[])new Object[0]);
        CashProperties cashProp = cashProperties.stream().filter(item -> Objects.equals(conditionDto.getParticipatorFlag(), item.getParticipatorType())).findAny().orElse(null);
        Validate.notNull((Object)cashProp, (String)"\u7cfb\u7edf\u7f3a\u5c11\u3010%s\u3011\u7c7b\u578b\u7684\u7ea2\u5305\u63d0\u73b0\u914d\u7f6e", (Object[])new Object[]{conditionDto.getParticipatorFlag()});
        conditionDto.setCashKey(cashProp.getCashKey());
    }

    private void cashValidate(RewardCashConditionDto conditionDto) {
        BaseIdEntity month;
        BaseIdEntity day;
        Date date;
        List<BaseIdEntity> months;
        List<MaxAmountLimitEntity> days;
        Map<String, List<BaseIdEntity>> map;
        List<RedPacketConfigEntity> configAll = this.redPacketConfigService.findAll();
        if (CollectionUtils.isEmpty(configAll)) {
            return;
        }
        RedPacketConfigEntity configEntity = configAll.stream().filter(redPacketConfigEntity -> redPacketConfigEntity.getType().equals(conditionDto.getParticipatorFlag())).findFirst().orElse(null);
        if (configEntity == null) {
            return;
        }
        if (configEntity.getIsAmountLimit() == 1) {
            BigDecimal balanceByParticipatorCode = this.redPacketService.findBalanceByParticipatorCode(conditionDto.getParticipatorCode());
            balanceByParticipatorCode = balanceByParticipatorCode == null ? BigDecimal.ZERO : balanceByParticipatorCode;
            Validate.isTrue((balanceByParticipatorCode.compareTo(configEntity.getAmountLimit()) >= 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u4f59\u989d\u4e0d\u6ee1\u8db3\u63d0\u73b0\u95e8\u69db\uff01", (Object[])new Object[0]);
        }
        if (configEntity.getIsOneCountLimit() == 1) {
            Validate.isTrue((conditionDto.getAmount().compareTo(configEntity.getOneAmountLimit()) < 1 ? 1 : 0) != 0, (String)"\u63d0\u73b0\u91d1\u989d\u8d85\u8fc7\u5355\u6b21\u6700\u9ad8\u63d0\u73b0\u91d1\u989d\uff01", (Object[])new Object[0]);
        }
        if (configEntity.getIsMaxAmountLimit() == 1) {
            BigDecimal bigDecimal;
            Set<MaxAmountLimitEntity> amountLimitDetails = configEntity.getAmountLimitDetails();
            Validate.isTrue((!CollectionUtils.isEmpty(amountLimitDetails) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u63d0\u73b0\u91d1\u989d\u4e0a\u9650\u8bbe\u7f6e", (Object[])new Object[0]);
            map = amountLimitDetails.stream().collect(Collectors.groupingBy(MaxAmountLimitEntity::getTimeType));
            days = map.get(DAY);
            months = map.get(MONTH);
            date = new Date();
            if (!CollectionUtils.isEmpty(days)) {
                day = days.get(0);
                bigDecimal = this.requestCashListener.onRequestAmountByParticipatorAndDateTime(conditionDto.getParticipatorCode(), conditionDto.getParticipatorFlag(), (Date)DateUtil.beginOfDay((Date)date), (Date)DateUtil.endOfDay((Date)date));
                Validate.isTrue((bigDecimal.add(conditionDto.getAmount()).compareTo(day.getAmountLimit()) < 1 ? 1 : 0) != 0, (String)"\u7d2f\u8ba1\u63d0\u73b0\u91d1\u989d\u5df2\u8d85\u8fc7\u4e0a\u9650\uff01", (Object[])new Object[0]);
            }
            if (!CollectionUtils.isEmpty(months)) {
                month = (MaxAmountLimitEntity)months.get(0);
                bigDecimal = this.requestCashListener.onRequestAmountByParticipatorAndDateTime(conditionDto.getParticipatorCode(), conditionDto.getParticipatorFlag(), (Date)DateUtil.beginOfMonth((Date)date), (Date)DateUtil.endOfMonth((Date)date));
                Validate.isTrue((bigDecimal.add(conditionDto.getAmount()).compareTo(month.getAmountLimit()) < 1 ? 1 : 0) != 0, (String)"\u7d2f\u8ba1\u63d0\u73b0\u91d1\u989d\u5df2\u8d85\u8fc7\u4e0a\u9650\uff01", (Object[])new Object[0]);
            }
        }
        if (configEntity.getIsMaxCountLimit() == 1) {
            Integer integer;
            Set<MaxCountLimitEntity> countLimitDetails = configEntity.getCountLimitDetails();
            Validate.isTrue((!CollectionUtils.isEmpty(countLimitDetails) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u7ea2\u5305\u63d0\u73b0\u6b21\u6570\u4e0a\u9650\u8bbe\u7f6e", (Object[])new Object[0]);
            map = countLimitDetails.stream().collect(Collectors.groupingBy(MaxCountLimitEntity::getTimeType));
            days = map.get(DAY);
            months = map.get(MONTH);
            date = new Date();
            if (!CollectionUtils.isEmpty(days)) {
                day = (MaxCountLimitEntity)((Object)days.get(0));
                integer = this.requestCashListener.onRequestCountByParticipatorAndDateTime(conditionDto.getParticipatorCode(), conditionDto.getParticipatorFlag(), (Date)DateUtil.beginOfDay((Date)date), (Date)DateUtil.endOfDay((Date)date));
                Validate.isTrue((integer + 1 <= day.getCountLimit() ? 1 : 0) != 0, (String)"\u7d2f\u8ba1\u63d0\u73b0\u6b21\u6570\u5df2\u8d85\u8fc7\u4e0a\u9650\uff01", (Object[])new Object[0]);
            }
            if (!CollectionUtils.isEmpty(months)) {
                month = (MaxCountLimitEntity)months.get(0);
                integer = this.requestCashListener.onRequestCountByParticipatorAndDateTime(conditionDto.getParticipatorCode(), conditionDto.getParticipatorFlag(), (Date)DateUtil.beginOfMonth((Date)date), (Date)DateUtil.endOfMonth((Date)date));
                Validate.isTrue((integer + 1 <= month.getCountLimit() ? 1 : 0) != 0, (String)"\u7d2f\u8ba1\u63d0\u73b0\u6b21\u6570\u5df2\u8d85\u8fc7\u4e0a\u9650\uff01", (Object[])new Object[0]);
            }
        }
    }
}

