/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.observer;

import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketScanCodeRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelScanCodeServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.ScanCodeRewardStatisticsVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="RedPacketRewardRelScanCodeServiceObserverImpl")
public class RedPacketRewardRelScanCodeServiceObserverImpl
implements RewardRelScanCodeServiceObserver {
    @Autowired
    @Qualifier(value="RedpacketRewardMountRegisterServiceImpl")
    private RewardMountRegister rewardMountRegister;
    @Autowired
    private RedPacketScanCodeRewardStatisticsVoService redPacketScanCodeRewardStatisticsVoService;

    public List<RewardRelScanCodeItemVo> onRequestRewardRelScanCodeItems(String participatorCode, List<String> recordCodes) {
        if (CollectionUtils.isEmpty(recordCodes) || StringUtils.isBlank((CharSequence)participatorCode)) {
            return null;
        }
        List result = this.redPacketScanCodeRewardStatisticsVoService.findByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        Map recordPolicyMap = result.stream().collect(Collectors.groupingBy(ScanCodeRewardStatisticsVo::getRecordCode, Collectors.mapping(ScanCodeRewardStatisticsVo::getPolicyName, Collectors.toList())));
        Map recordTemplateMap = result.stream().collect(Collectors.groupingBy(ScanCodeRewardStatisticsVo::getRecordCode, Collectors.mapping(ScanCodeRewardStatisticsVo::getTemplateCode, Collectors.toList())));
        Map recordSumAmountMap = result.stream().collect(Collectors.groupingBy(ScanCodeRewardStatisticsVo::getRecordCode, Collectors.mapping(ScanCodeRewardStatisticsVo::getAmount, Collectors.toList())));
        ArrayList list = Lists.newArrayList();
        for (String recordCode : recordCodes) {
            RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
            List templateCodes = recordTemplateMap.get(recordCode);
            List amountCodes = recordSumAmountMap.get(recordCode);
            List policyNames = recordPolicyMap.get(recordCode);
            if (CollectionUtils.isEmpty(templateCodes)) continue;
            BigDecimal totalAmount = amountCodes.stream().reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            vo.setName(this.rewardMountRegister.getName());
            vo.setFlag(this.rewardMountRegister.getFlag());
            vo.setKey(this.rewardMountRegister.getKey());
            vo.setAmount(totalAmount);
            RewardRelScanCodeItemVo item = new RewardRelScanCodeItemVo();
            item.setRecordCode(recordCode);
            item.setTemplateCodes(templateCodes);
            item.setPolicyNames((Set)Sets.newHashSet(policyNames));
            item.setRewardStatisticsVo(vo);
            list.add(item);
        }
        return list;
    }
}

