/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketDetailVoService;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketDetailVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class RedPacketDetailVoServiceImpl
implements RedPacketDetailVoService {
    @Autowired
    private RedPacketDetailService redPacketDetailService;
    @Autowired
    private AgreementVoService agreementVoService;

    public Page<RedPacketDetailVo> findByParticipatorCodeAndCreateTimeAndType(String participatorCode, String yearAndMonth, String type, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)participatorCode)) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        RedPacketDetailDto queryDto = new RedPacketDetailDto();
        queryDto.setParticipatorCode(participatorCode);
        queryDto.setType(type);
        queryDto.setTenantCode(TenantUtils.getTenantCode());
        Page<RedPacketDetailEntity> result = this.redPacketDetailService.findByConditions(pageable, queryDto);
        if (Objects.isNull(result)) {
            return new Page();
        }
        List details = result.getRecords();
        ArrayList<RedPacketDetailVo> vos = new ArrayList<RedPacketDetailVo>();
        for (RedPacketDetailEntity entity : details) {
            RedPacketDetailVo vo = new RedPacketDetailVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            LoginUserAgreementDto dto = new LoginUserAgreementDto();
            dto.setTerminalCode(participatorCode);
            dto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{entity.getTemplateCode()}));
            List agreements = this.agreementVoService.findByConditions(dto);
            if (CollectionUtils.isNotEmpty((Collection)agreements)) {
                vo.setAgreementCode(((AgreementVo)agreements.get(0)).getAgreementCode());
                vo.setAgreementName(((AgreementVo)agreements.get(0)).getAgreementName());
            }
            vos.add(vo);
        }
        Page page = new Page();
        page.setCurrent(result.getCurrent());
        page.setSize(result.getSize());
        page.setTotal(result.getTotal());
        page.setRecords(vos);
        return page;
    }
}

