/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.CustomerRedPacketBalanceDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u6237\u7ea2\u5305"})
@RestController
@RequestMapping(value={"/v1/redPacket/custom"})
public class RedPacketController {
    private static final Logger log = LoggerFactory.getLogger(RedPacketController.class);
    @Autowired
    private RedPacketService redPacketService;
    @Autowired
    private LoginUserService loginUserService;

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5206\u5ba2\u6237\u7ea2\u5305\u5217\u8868")
    @GetMapping(value={"findByConditions"})
    public Result<Page<RedPacketEntity>> findByConditions(@ApiParam(name="balanceDto", value="\u5ba2\u6237\u4f59\u989ddto") CustomerRedPacketBalanceDto balanceDto, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<RedPacketEntity> page = this.redPacketService.findByConditions(balanceDto, pageable);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec8\u7aef/\u7ecf\u9500\u5546 \u7ea2\u5305\u4f59\u989d")
    @GetMapping(value={"findByCurrentUser"})
    public Result<RedPacketEntity> findByCurrentUser() {
        try {
            LoginUserDetails userDetails = this.loginUserService.getLoginUser();
            RedPacketEntity redPacket = this.redPacketService.findByParticipatorCode(userDetails.getConsumerCode());
            if (Objects.nonNull((Object)redPacket)) {
                BigDecimal balance = redPacket.getBalance() == null ? BigDecimal.ZERO : redPacket.getBalance();
                redPacket.setBalance(balance.setScale(2, RoundingMode.HALF_UP));
            }
            return Result.ok((Object)((Object)redPacket));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

