/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.KeepBooksRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDto;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepBooksServiceImpl
implements KeepBooksService {
    @Autowired
    private KeepBooksRepository keepBooksRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public Page<KeepBooksEntity> findByConditions(Pageable pageable, KeepBooksDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new KeepBooksDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.keepBooksRepository.findByConditions(pageable, dto);
    }

    @Override
    public BigDecimal sumByLastDay(String lastDay) {
        Validate.notBlank((CharSequence)lastDay, (String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal keepBooks = this.keepBooksRepository.sumByLastDay(lastDay);
        if (keepBooks == null) {
            return BigDecimal.ZERO;
        }
        return keepBooks;
    }

    @Override
    public KeepBooksEntity findTop1() {
        return this.keepBooksRepository.findTop1();
    }

    @Override
    @Transactional
    public void updateTop1SubBalance(BigDecimal amount) {
        KeepBooksEntity booksEntity = this.findTop1();
        Validate.notNull((Object)((Object)booksEntity), (String)"\u8d26\u6237\u8bb0\u5f55\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        BigDecimal balance = booksEntity.getBalance() == null ? BigDecimal.ZERO : booksEntity.getBalance().setScale(4, RoundingMode.HALF_UP);
        int flag = balance.compareTo(amount);
        Validate.isTrue((flag >= 0 ? 1 : 0) != 0, (String)"\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\uff01", (Object[])new Object[0]);
        booksEntity.setBalance(balance.subtract(amount).setScale(4, RoundingMode.HALF_UP));
        this.keepBooksRepository.updateById((Object)booksEntity);
    }

    @Override
    public KeepBooksEntity create(KeepBooksDto keepBooksDto) {
        this.validateCreate(keepBooksDto);
        KeepBooksEntity top1 = this.findTop1();
        BigDecimal balance = BigDecimal.ZERO;
        if (top1 != null) {
            balance = top1.getBalance();
        }
        KeepBooksEntity create = new KeepBooksEntity();
        create.setCode("1");
        create.setTenantCode(TenantUtils.getTenantCode());
        create.setRemark(keepBooksDto.getRemark());
        create.setAmount(keepBooksDto.getAmount());
        create.setBalance(balance.add(keepBooksDto.getAmount()));
        create.setCreateAccount(this.loginUserService.getLoginAccountName());
        create.setCreateTime(new Date());
        this.keepBooksRepository.save((Object)create);
        return create;
    }

    private void validateCreate(KeepBooksDto keepBooksDto) {
        Validate.notNull((Object)keepBooksDto, (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)keepBooksDto.getAmount(), (String)"\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)keepBooksDto.getRemark(), (String)"\u4e0a\u8d26\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

