/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.MessageTypeEnum;
import com.biz.crm.cps.business.common.sdk.event.BusinessMessageEvent;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketDetailRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksService;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDto;
import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalPhoneAndOrgVo;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;

@Service
public class RedPacketDetailServiceImpl
implements RedPacketDetailService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketDetailServiceImpl.class);
    @Autowired
    private RedPacketDetailRepository redPacketDetailRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private RedPacketService redPacketService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private KeepBooksService keepBooksService;
    @Value(value="${rocketmq.topic:}")
    private String destination;
    @Value(value="${url.redPackage:}")
    private String url;
    @Autowired
    private RocketMQTemplate mqTemplate;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Override
    public Page<RedPacketDetailEntity> findByConditions(Pageable pageable, RedPacketDetailDto dto) {
        Set codes;
        List mdmVos;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new RedPacketDetailDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<RedPacketDetailEntity> page = this.redPacketDetailRepository.findByConditions(pageable, dto);
        List entities = page.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)entities) && CollectionUtils.isNotEmpty((Collection)(mdmVos = (List)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.queryPhoneAndOrgByTerminalCode((List)Lists.newArrayList(codes = entities.stream().map(RedPacketDetailEntity::getParticipatorCode).collect(Collectors.toSet()))), (boolean)true)))) {
            Map<String, List<MdmTerminalPhoneAndOrgVo>> mdmVoMap = mdmVos.stream().collect(Collectors.groupingBy(MdmTerminalPhoneAndOrgVo::getTerminalCode));
            page.getRecords().forEach(x -> {
                if (mdmVoMap.containsKey(x.getParticipatorCode())) {
                    HashSet nameSet = Sets.newHashSet();
                    HashSet codeSet = Sets.newHashSet();
                    HashSet phoneSet = Sets.newHashSet();
                    ((List)mdmVoMap.get(x.getParticipatorCode())).forEach(y -> {
                        nameSet.add(y.getOrgName());
                        codeSet.add(y.getOrgCode());
                        phoneSet.add(y.getUserPhone());
                    });
                    x.setOrgCode(String.join((CharSequence)",", codeSet));
                    x.setOrgName(String.join((CharSequence)",", nameSet));
                    x.setPhone(String.join((CharSequence)",", phoneSet));
                }
            });
        }
        return page;
    }

    @Override
    public BigDecimal sumByLastDay(String lastDay) {
        Validate.notBlank((CharSequence)lastDay, (String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal amount = this.redPacketDetailRepository.sumByLastDay(lastDay);
        if (amount == null) {
            return BigDecimal.ZERO;
        }
        return amount;
    }

    @Override
    @Transactional
    public RedPacketDetailEntity create(RedPacketDetailDto redPacketDetailDto) {
        log.debug("\u65b0\u589e\u7ea2\u5305\u6d41\u6c34\u4f20\u5165\u53c2\u6570={}", (Object)redPacketDetailDto);
        RedPacketDetailEntity redPacketDetail = (RedPacketDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPacketDetailDto, RedPacketDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.createForm(redPacketDetail);
        BigDecimal balance = BigDecimal.ZERO;
        RedPacketEntity result = null;
        RedPacketEntity old = this.redPacketService.findByParticipatorCode(redPacketDetail.getParticipatorCode());
        boolean add = IncomeStatusEnum.ADD.equals((Object)redPacketDetailDto.getType());
        if (old != null) {
            RedPacketDto redPacketDto = (RedPacketDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)old, RedPacketDto.class, HashSet.class, ArrayList.class, new String[0]);
            if (add) {
                this.addRedPacket(redPacketDetailDto);
            } else {
                this.redPacketService.updateBalance(redPacketDetailDto.getParticipatorCode(), redPacketDetailDto.getAmount(), IncomeStatusEnum.getByDictCode((String)redPacketDetailDto.getType()));
            }
            RedPacketEntity current = this.redPacketService.findByParticipatorCode(redPacketDetail.getParticipatorCode());
            balance = current.getBalance();
            result = current;
            this.redPacketService.updateBaseInfo(redPacketDto);
        } else {
            Validate.isTrue((boolean)Objects.equals(IncomeStatusEnum.ADD.getDictCode(), redPacketDetail.getType()), (String)"\u8fd8\u672a\u83b7\u53d6\u5230\u7ea2\u5305", (Object[])new Object[0]);
            RedPacketDto redPacket = (RedPacketDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPacketDetailDto, RedPacketDto.class, HashSet.class, ArrayList.class, new String[0]);
            balance = new BigDecimal("0");
            redPacket.setBalance(balance);
            redPacket.setAccruingRedPacket(balance);
            result = this.redPacketService.create(redPacket);
            this.addRedPacket(redPacketDetailDto);
        }
        if (Objects.equals(IncomeStatusEnum.ADD.getDictCode(), redPacketDetail.getType())) {
            this.keepBooksService.updateTop1SubBalance(redPacketDetail.getAmount());
        }
        Validate.notNull((Object)((Object)result), (String)"\u672a\u627e\u5230\u7ea2\u5305\u4f59\u989d", (Object[])new Object[0]);
        redPacketDetail.setBalance(balance.add(redPacketDetailDto.getAmount()));
        redPacketDetail.setRedPacketId(result.getId());
        redPacketDetail.setStatus("0");
        this.redPacketDetailRepository.saveOrUpdate((Object)redPacketDetail);
        BusinessMessageEvent event = new BusinessMessageEvent();
        event.setTitle("\u7ea2\u5305\u6d88\u606f");
        event.setCode(this.url + this.loginUserService.getLoginAccountName());
        event.setContent(redPacketDetail.getAmount().toPlainString());
        event.setType(MessageTypeEnum.RED_PACKET.getCode());
        event.setOwner(redPacketDetail.getParticipatorCode());
        event.setPushDate(Long.valueOf(System.currentTimeMillis()));
        this.mqTemplate.syncSendOrderly("MESSAGE_TOPIC", MessageBuilder.withPayload((Object)event).build(), "MESSAGE_GROUP");
        return redPacketDetail;
    }

    private void addRedPacket(RedPacketDetailDto redPacketDetailDto) {
        this.redPacketService.updateAccumulative(redPacketDetailDto.getParticipatorCode(), redPacketDetailDto.getAmount());
        this.redPacketService.updateFrozenAmount(redPacketDetailDto.getParticipatorCode(), redPacketDetailDto.getAmount());
    }

    @Override
    @Transactional
    public RedPacketDetailEntity update(RedPacketDetailEntity redPacketDetail) {
        RedPacketDetailEntity current = this.updateForm(redPacketDetail);
        return current;
    }

    private RedPacketDetailEntity updateForm(RedPacketDetailEntity redPacketDetail) {
        this.updateValidation(redPacketDetail);
        String currentId = redPacketDetail.getId();
        RedPacketDetailEntity current = (RedPacketDetailEntity)((Object)this.redPacketDetailRepository.getById((Serializable)((Object)currentId)));
        current = (RedPacketDetailEntity)((Object)Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        BeanUtils.copyProperties((Object)((Object)redPacketDetail), (Object)((Object)current), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode"});
        Date now = new Date();
        String account = this.loginUserService.getLoginAccountName();
        current.setModifyAccount(account);
        current.setModifyTime(now);
        this.redPacketDetailRepository.saveOrUpdate((Object)current);
        return current;
    }

    private RedPacketDetailEntity createForm(RedPacketDetailEntity redPacketDetail) {
        if (Objects.nonNull(this.generateCodeService)) {
            redPacketDetail.setCode((String)this.generateCodeService.generateCode("red_packet_detail_code", 1).get(0));
        }
        redPacketDetail.setTenantCode(TenantUtils.getTenantCode());
        redPacketDetail.setCreateTime(new Date());
        redPacketDetail.setCreateAccount(this.loginUserService.getLoginAccountName());
        redPacketDetail.setModifyTime(new Date());
        redPacketDetail.setModifyAccount(this.loginUserService.getLoginAccountName());
        redPacketDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        redPacketDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)redPacketDetail.getSourceNumber())) {
            redPacketDetail.setSourceNumber((String)this.generateCodeService.generateCode("source_number", 1).get(0));
        }
        this.createValidation(redPacketDetail);
        return redPacketDetail;
    }

    private void createValidation(RedPacketDetailEntity redPacketDetail) {
        Validate.notNull((Object)((Object)redPacketDetail), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDetail.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDetail.getParticipatorName(), (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((redPacketDetail.getParticipatorCode().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDetail.getParticipatorName().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void updateValidation(RedPacketDetailEntity redPacketDetail) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)redPacketDetail.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDetail.getParticipatorType(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDetail.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDetail.getParticipatorName(), (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((redPacketDetail.getParticipatorType().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDetail.getParticipatorCode().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDetail.getParticipatorName().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public List<RedPacketDetailEntity> findByParticipatorCodeAndCreateTime(String participatorCode, String yearAndMonth) {
        if (StringUtils.isBlank((CharSequence)participatorCode)) {
            return Lists.newArrayList();
        }
        return this.redPacketDetailRepository.findByParticipatorCodeAndCreateTime(participatorCode, yearAndMonth);
    }

    @Override
    public BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(recordCodes, (String)"\u626b\u7801\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BigDecimal total = this.redPacketDetailRepository.sumByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
        return total;
    }

    @Override
    public BigDecimal sumByTenantCodeAndTriggerAction(String tenantCode, String triggerAction) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || StringUtils.isBlank((CharSequence)triggerAction)) {
            return null;
        }
        return this.redPacketDetailRepository.sumByTenantCodeAndTriggerAction(tenantCode, triggerAction);
    }

    @Override
    public BigDecimal sumIssueAmount() {
        List entities = this.redPacketDetailRepository.lambdaQuery().list();
        List detailEntities = entities.stream().filter(o -> o.getAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        return detailEntities.stream().map(RedPacketDetailEntity::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

