/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.CustomerRedPacketBalanceDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDto;
import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalPhoneAndOrgVo;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"RedPacketServiceExpandImpl"})
public class RedPacketServiceImpl
implements RedPacketService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketServiceImpl.class);
    @Autowired
    private RedPacketRepository redPacketRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Override
    public Page<RedPacketEntity> findByConditions(CustomerRedPacketBalanceDto balanceDto, Pageable pageable) {
        Set codes;
        List mdmVos;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (balanceDto == null) {
            balanceDto = new CustomerRedPacketBalanceDto();
        }
        balanceDto.setTenantCode(TenantUtils.getTenantCode());
        Page<RedPacketEntity> pageEntities = this.redPacketRepository.findByConditions(pageable, balanceDto);
        List entities = pageEntities.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)entities) && CollectionUtils.isNotEmpty((Collection)(mdmVos = (List)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.queryPhoneAndOrgByTerminalCode((List)Lists.newArrayList(codes = entities.stream().map(RedPacketEntity::getParticipatorCode).collect(Collectors.toSet()))), (boolean)true)))) {
            Map<String, List<MdmTerminalPhoneAndOrgVo>> mdmVoMap = mdmVos.stream().collect(Collectors.groupingBy(MdmTerminalPhoneAndOrgVo::getTerminalCode));
            pageEntities.getRecords().forEach(x -> {
                if (mdmVoMap.containsKey(x.getParticipatorCode())) {
                    HashSet nameSet = Sets.newHashSet();
                    HashSet codeSet = Sets.newHashSet();
                    HashSet phoneSet = Sets.newHashSet();
                    ((List)mdmVoMap.get(x.getParticipatorCode())).forEach(y -> {
                        nameSet.add(y.getOrgName());
                        codeSet.add(y.getOrgCode());
                        phoneSet.add(y.getUserPhone());
                    });
                    x.setOrgCode(String.join((CharSequence)",", codeSet));
                    x.setOrgName(String.join((CharSequence)",", nameSet));
                    x.setPhone(String.join((CharSequence)",", phoneSet));
                }
            });
        }
        return pageEntities;
    }

    @Override
    public RedPacketEntity findByParticipatorCode(String participatorCode) {
        if (StringUtils.isBlank((String)participatorCode)) {
            return null;
        }
        return this.redPacketRepository.findByParticipatorCode(participatorCode);
    }

    @Override
    @Transactional
    public RedPacketEntity create(RedPacketDto redPacketDto) {
        log.debug("\u4fdd\u5b58\u7ea2\u5305\u4fe1\u606f\u5165\u53c2={}", (Object)redPacketDto);
        this.createValidation(redPacketDto);
        RedPacketEntity redPacketEntity = (RedPacketEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPacketDto, RedPacketEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.createForm(redPacketEntity);
        this.redPacketRepository.saveOrUpdate((Object)redPacketEntity);
        return redPacketEntity;
    }

    @Override
    @Transactional
    public RedPacketEntity update(RedPacketDto redPacketDto) {
        this.updateValidation(redPacketDto);
        RedPacketEntity redPacketEntity = (RedPacketEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPacketDto, RedPacketEntity.class, HashSet.class, ArrayList.class, new String[0]));
        RedPacketEntity old = (RedPacketEntity)((Object)this.redPacketRepository.getById((Serializable)((Object)redPacketEntity.getId())));
        Validate.notNull((Object)((Object)old), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)redPacketEntity), (Object)((Object)old), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode", "balance", "accruingRedPacket"});
        if (redPacketDto.getAccruingRedPacket() != null) {
            old.setAccruingRedPacket(redPacketDto.getAccruingRedPacket());
        }
        if (redPacketDto.getBalance() != null) {
            old.setBalance(redPacketDto.getBalance());
        }
        Date now = new Date();
        String account = this.loginUserService.getLoginAccountName();
        old.setModifyAccount(account);
        old.setModifyTime(now);
        this.redPacketRepository.saveOrUpdate((Object)old);
        return old;
    }

    @Override
    @Transactional
    public void updateBalance(String participatorCode, BigDecimal amount, IncomeStatusEnum incomeStatus) {
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)amount, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)incomeStatus, (String)"\u6536\u76ca\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (IncomeStatusEnum.ADD == incomeStatus) {
            long count = this.redPacketRepository.addBalance(participatorCode, amount);
            Validate.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u7ea2\u5305\u4f59\u989d\u65b0\u589e\u5931\u8d25", (Object[])new Object[0]);
        } else if (IncomeStatusEnum.SUBTRACT == incomeStatus) {
            long count = this.redPacketRepository.subtractBalance(participatorCode, amount);
            Validate.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u7ea2\u5305\u4f59\u989d\u6263\u51cf\u5931\u8d25", (Object[])new Object[0]);
        }
    }

    @Override
    public void updateFrozenAmount(String participatorCode, BigDecimal amount) {
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)amount, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RedPacketEntity redPacket = this.redPacketRepository.findByParticipatorCode(participatorCode);
        if (redPacket.getFrozenAmount() == null) {
            redPacket.setFrozenAmount(new BigDecimal("0"));
        }
        redPacket.setFrozenAmount(redPacket.getFrozenAmount().add(amount));
        this.redPacketRepository.updateById((Object)redPacket);
    }

    @Override
    public void updateBalance(String participatorCode, BigDecimal amount) {
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)amount, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RedPacketEntity redPacket = this.redPacketRepository.findByParticipatorCode(participatorCode);
        redPacket.setBalance(redPacket.getBalance().add(amount));
        this.redPacketRepository.updateById((Object)redPacket);
    }

    @Override
    public void updateAccumulative(String participatorCode, BigDecimal amount) {
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)amount, (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RedPacketEntity redPacket = this.redPacketRepository.findByParticipatorCode(participatorCode);
        redPacket.setAccruingRedPacket(redPacket.getAccruingRedPacket().add(amount));
        this.redPacketRepository.updateById((Object)redPacket);
    }

    @Override
    @Transactional
    public void updateBaseInfo(RedPacketDto redPacketDto) {
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.redPacketRepository.updateBaseInfo(redPacketDto);
    }

    @Override
    public BigDecimal findBalanceByParticipatorCode(String participatorCode) {
        if (StringUtils.isBlank((String)participatorCode)) {
            return BigDecimal.ZERO;
        }
        return this.redPacketRepository.findBalanceByParticipatorCode(participatorCode);
    }

    private void updateValidation(RedPacketDto redPacketDto) {
        Validate.notNull((Object)redPacketDto, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4fee\u6539\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorType().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorCode().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorName().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void createValidation(RedPacketDto redPacketDto) {
        Validate.notNull((Object)redPacketDto, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorType(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorName(), (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorType().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorCode().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorName().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void createForm(RedPacketEntity redPacketEntity) {
        redPacketEntity.setId(null);
        redPacketEntity.setTenantCode(TenantUtils.getTenantCode());
        redPacketEntity.setCreateTime(new Date());
        redPacketEntity.setCreateAccount(this.loginUserService.getLoginAccountName());
        redPacketEntity.setModifyTime(new Date());
        redPacketEntity.setModifyAccount(this.loginUserService.getLoginAccountName());
        redPacketEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        redPacketEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }
}

