/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.KeepBooksDetailRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksDetailService;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDto;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepBooksDetailServiceImpl
implements KeepBooksDetailService {
    @Autowired
    private KeepBooksDetailRepository keepBooksDetailRepository;
    @Autowired
    private KeepBooksService keepBooksService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<KeepBooksDetailEntity> findByConditions(Pageable pageable, KeepBooksDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new KeepBooksDetailDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.keepBooksDetailRepository.findByConditions(pageable, dto);
    }

    @Override
    public BigDecimal sumByLastDay(String lastDay) {
        Validate.notBlank((CharSequence)lastDay, (String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal keepBooks = this.keepBooksDetailRepository.sumByLastDay(lastDay);
        if (keepBooks == null) {
            return BigDecimal.ZERO;
        }
        return keepBooks;
    }

    @Override
    @Transactional
    public KeepBooksDetailEntity create(KeepBooksDetailDto dto) {
        this.validateCreate(dto);
        KeepBooksDto keepBooksDto = (KeepBooksDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, KeepBooksDto.class, HashSet.class, ArrayList.class, new String[0]);
        KeepBooksEntity result = this.keepBooksService.create(keepBooksDto);
        KeepBooksDetailEntity create = new KeepBooksDetailEntity();
        create.setTenantCode(TenantUtils.getTenantCode());
        Validate.notNull((Object)this.generateCodeService, (String)"\u6ca1\u6709\u7f16\u7801\u751f\u6210\u5668", (Object[])new Object[0]);
        create.setCode((String)this.generateCodeService.generateCode("red_packet_keepbooks_detail_code", 1).get(0));
        create.setRemark(dto.getRemark());
        create.setAmount(dto.getAmount());
        create.setBalance(result.getBalance());
        create.setCreateAccount(this.loginUserService.getLoginAccountName());
        create.setCreateTime(new Date());
        create.setKeepBooksId(result.getId());
        this.keepBooksDetailRepository.save((Object)create);
        return create;
    }

    private void validateCreate(KeepBooksDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAmount(), (String)"\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRemark(), (String)"\u4e0a\u8d26\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

