/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksDetailService;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksService;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketBalanceVoService;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketStatisticsDayVoService;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketBalanceVo;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketStatisticsDayVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedPacketBalanceVoServiceImpl
implements RedPacketBalanceVoService {
    @Autowired
    private KeepBooksService keepBooksService;
    @Autowired
    private KeepBooksDetailService keepBooksDetailService;
    @Autowired
    private RedPacketDetailService redPacketDetailService;
    @Autowired
    private RedPacketStatisticsDayVoService redPacketStatisticsDayVoService;

    public RedPacketBalanceVo findByStatisticsDay(Integer statisticsDay) {
        if (statisticsDay == null) {
            return null;
        }
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1 - statisticsDay);
        String startDay = sdf.format(c.getTime());
        c.setTime(date);
        c.add(5, -1);
        String lastDay = sdf.format(c.getTime());
        List amountList = this.redPacketStatisticsDayVoService.findByStartDay(startDay);
        RedPacketBalanceVo vo = new RedPacketBalanceVo();
        KeepBooksEntity balance = this.keepBooksService.findByTenantCode(TenantUtils.getTenantCode());
        vo.setBalance(balance == null ? BigDecimal.ZERO : balance.getBalance());
        BigDecimal yesterdayAmount = this.redPacketDetailService.sumByLastDay(lastDay);
        vo.setYesterdayAmount(yesterdayAmount);
        BigDecimal keepBooks = this.keepBooksDetailService.sumByLastDay(lastDay);
        vo.setYesterdayKeepBooks(keepBooks);
        BigDecimal amount = BigDecimal.ZERO;
        for (RedPacketStatisticsDayVo value : amountList) {
            amount = amount.add(value.getAmount());
        }
        vo.setAverageAmount(amount.divide(new BigDecimal(statisticsDay), 2, RoundingMode.HALF_UP));
        vo.setStatisticsDay(statisticsDay);
        BigDecimal averageAmount = vo.getAverageAmount() == null || vo.getAverageAmount().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : vo.getAverageAmount();
        vo.setPredictDay(Integer.valueOf(Integer.parseInt(vo.getBalance().divide(averageAmount, 0, 1).toString())));
        vo.setAmountList(amountList);
        return vo;
    }
}

