/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketDetailRepository;
import com.biz.crm.cps.business.reward.redpacket.sdk.common.constant.enums.SendTpmStatusEnum;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.TPMRedpacketRecordService;
import com.biz.crm.cps.external.feign.service.CpsTpmFeign;
import com.biz.crm.nebular.tpm.actcenter.FeeBudgetChangeVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class TPMRedpacketRecordServiceImpl
implements TPMRedpacketRecordService {
    private static final Logger log = LoggerFactory.getLogger(TPMRedpacketRecordServiceImpl.class);
    @Autowired
    private RedPacketDetailRepository redPacketDetailRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private CpsTpmFeign cpsTpmFeign;

    @Transactional
    public boolean tpmRedpacketDeduction() {
        Map<String, Date> map = this.getTimeByCalender();
        List<RedPacketDetailEntity> list = this.redPacketDetailRepository.findByDate(map.get("startTime"), map.get("endTime"));
        log.info("tpm\u7ea2\u5305\u6263\u51cf={}", (Object)JSONObject.toJSONString(list));
        if (!CollectionUtils.isEmpty(list)) {
            BigDecimal total = new BigDecimal(0);
            ArrayList detailEntities = Lists.newArrayList();
            String tpmBusiness = (String)this.generateCodeService.generateCode("CPS_budget_code", 1).get(0);
            for (RedPacketDetailEntity entity : list) {
                if (!StringUtils.isNotBlank((CharSequence)entity.getSendTpmCode()) || SendTpmStatusEnum.YES.getCode().equals(entity.getSendTpmStatus())) continue;
                total = total.add(entity.getAmount());
                entity.setSendTpmStatus(SendTpmStatusEnum.YES.getCode());
                entity.setSendTpmCode(tpmBusiness);
                detailEntities.add(entity);
            }
            FeeBudgetChangeVo vo = new FeeBudgetChangeVo();
            vo.setBusinessCode(tpmBusiness);
            vo.setAmount(total);
            vo.setIsDeduction(Boolean.valueOf(true));
            vo.setCustomerCode("CPS");
            vo.setCustomerName("CPS\u7ea2\u5305");
            log.info("tpm\u7ea2\u5305\u6263\u51cf\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)vo));
            Result result = this.cpsTpmFeign.feeBudgetChange(vo);
            log.info("tpm\u7ea2\u5305\u6263\u51cf\u8fd4\u56de={}", (Object)JSONObject.toJSONString((Object)result));
            if (Objects.nonNull(result) && result.isSuccess()) {
                this.redPacketDetailRepository.saveOrUpdateBatch(detailEntities);
                return true;
            }
            return false;
        }
        return true;
    }

    public Map<String, Date> getTimeByCalender() {
        Hashtable<String, Date> map = new Hashtable<String, Date>();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date startTime = calendar.getTime();
        map.put("startTime", startTime);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date endTime = calendar.getTime();
        map.put("endTime", endTime);
        return map;
    }
}

