/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.sdk.service.RewardCashVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ea2\u5305\u63d0\u73b0\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/redPacket/rewardCashVo"})
public class RedPacketRewardCashVoController {
    private static final Logger log = LoggerFactory.getLogger(RedPacketRewardCashVoController.class);
    @Autowired
    private RewardCashVoService rewardCashVoService;

    @ApiOperation(value="\u6d88\u8d39\u8005\u626b\u7801\u5956\u52b1\u7edf\u8ba1")
    @GetMapping(value={"/findByConsumerOpenIdRecordCodes"})
    public Result<BigDecimal> findByConsumerOpenIdRecordCodes(@RequestParam(value="recordCodes") List<String> recordCodes, @RequestParam(value="openId") String openId) {
        try {
            BigDecimal total = this.rewardCashVoService.findByConsumerOpenIdRecordCodes(openId, recordCodes);
            return Result.ok((Object)total);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec8\u7aef/\u7ecf\u9500\u5546\u7ea2\u5305\u63d0\u73b0", notes="\u7ec8\u7aef/\u7ecf\u9500\u5546\u7ea2\u5305\u63d0\u73b0")
    @PostMapping(value={"withdraw"})
    public Result<Boolean> withdraw(@RequestParam(value="amount") BigDecimal amount) {
        try {
            this.rewardCashVoService.currentUserCash(amount);
            return Result.ok((Object)true);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d88\u8d39\u8005\u7ea2\u5305\u63d0\u73b0", notes="\u6d88\u8d39\u8005\u7ea2\u5305\u63d0\u73b0")
    @PostMapping(value={"consumerWithdraw"})
    public Result<Boolean> consumerWithdraw(@RequestParam(value="amount") BigDecimal amount, @RequestParam(value="openId") String openId) {
        try {
            this.rewardCashVoService.consumerCash(amount, openId);
            return Result.ok((Object)true);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

