package com.biz.crm.cps.business.reward.redpacket.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 客户红包余额Dto
 * @Author: zengxingwang
 * @Date: 2021/8/5 16:43
 */
@Data
@ApiModel(value = "CustomerRedPacketBalanceDto", description = "客户红包余额Dto")
public class CustomerRedPacketBalanceDto {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String participatorCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String participatorName;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String participatorType;

  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  private String phone;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channel;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  private String tag;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 开始更新时间
   */
  @ApiModelProperty("开始更新时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date startUpdateTime;

  /**
   * 结束更新时间
   */
  @ApiModelProperty("结束更新时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date endUpdateTime;

  /**
   * 租户编号
   */
  @ApiModelProperty(value = "租户编号")
  private String tenantCode;
}
