package com.biz.crm.cps.business.reward.redpacket.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: KeepBooksDto
 * @Author: yangfan
 * @Description: 上账记录dto
 * @Date: 2021/8/7 15:40
 * @Version: 1.0
 */

@Data
@ApiModel(value = "KeepBooksDto", description = "上账记录Dto")
public class KeepBooksDto {

    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
    private Date endTime;

    /**
     * 上账金额
     */
    @ApiModelProperty("上账金额")
    private BigDecimal amount;

    /**
     * 上账描述
     */
    @ApiModelProperty("上账描述")
    private String remark;

    /**
     * 租户编号 不用向外暴露
     */
    private String tenantCode;
}
