package com.biz.crm.cps.business.reward.redpacket.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 红包流水Dto
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 16:48
 */
@Data
@ApiModel(value = "RedPacketDetailDto", description = "红包流水Dto")
public class RedPacketDetailDto {

  /**
   * 红包变动流水编码
   */
  @ApiModelProperty("红包变动流水编码")
  private String code;

  /**
   * 参与者类型
   */
  @ApiModelProperty("参与者类型")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称")
  private String participatorName;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String phone;

  /**
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  private String triggerObject;

  /**
   * 开始发放时间
   */
  @ApiModelProperty("开始发放时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startReleaseTime;

  /**
   * 结束发放时间
   */
  @ApiModelProperty("结束发放时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endReleaseTime;

  /**
   * 红包id
   */
  @ApiModelProperty("红包id")
  private String redPacketId;

  /**
   * 租户编号 不用向外暴露
   */
  private String tenantCode;


  /**
   * 参与者所属机构编码
   */
  @ApiModelProperty("参与者所属机构编码")
  private String orgCode;

  /**
   * 参与者所属机构名称
   */
  @ApiModelProperty("参与者所属机构名称")
  private String orgName;

  /**
   * 参与者所属渠道
   */
  @ApiModelProperty("参与者所属渠道")
  private String channel;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  private String agreementCode;

  /**
   * 模版编码
   */
  @ApiModelProperty("模版编码")
  private String templateCode;
  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("政策名称")
  private String policyName;
  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  private String recordCode;
  /**
   * 变动金额
   */
  @ApiModelProperty("变动金额")
  private BigDecimal amount;
  /**
   * 操作类型，1：增加 2：减少
   */
  @ApiModelProperty("操作类型，1：增加 2：减少")
  private String type;
  /**
   * 年月yyyy-MM
   */
  @ApiModelProperty("年月 yyyy-MM")
  private String yearAndMonth;

  /**
   * 返利类型 (正向，反向)
   */
  @ApiModelProperty("返利类型 (正向，反向)")
  private String rebateType;

  /**
   * 客户所属组织
   */
  @ApiModelProperty("客户所属组织")
  private String customerOrganization;

  /**
   * 终端/经销商类型
   */
  @ApiModelProperty("终端/经销商类型")
  private String detailType;

  /**
   * 模板名称
   */
  @ApiModelProperty("模板名称")
  private String templateName;

  /**
   * 微信昵称
   */
  @ApiModelProperty("微信昵称")
  private String nickname;


  /**
   * 开始创建时间
   */
  @ApiModelProperty("开始创建时间")
  private String startCreateTime;

  /**
   * 结束创建时间
   */
  @ApiModelProperty("结束创建时间")
  private String endCreateTime;

  @ApiModelProperty("所属组织")
  private String organization;

  /**
   * 关联业务类型
   *
   * @see CostRelateType dictCode
   */
  @ApiModelProperty("关联业务类型")
  private String relateType;

  /**
   * 关联业务流号 协议活动号、扫码活动编码
   */
  @ApiModelProperty("关联业务流号-协议活动号、扫码活动编码")
  private String relateCode;
}
