package com.biz.crm.cps.business.reward.redpacket.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Set;
import lombok.Data;

/**
 * @ClassName: RedPacketDto
 * @Author: yangfan
 * @Description: 红包dto
 * @Date: 2021/8/10 11:20
 * @Version: 1.0
 */

@Data
@ApiModel(value = "RedPacketDto", description = "红包Dto")
public class RedPacketDto {

  /**
   * 红包主键
   */
  @ApiModelProperty("红包主键")
  private String id;
  /**
   * 参与者编码
   */
  @ApiModelProperty("客户编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("客户名称")
  private String participatorName;

  /**
   * 参与者类型
   */
  @ApiModelProperty("客户类型")
  private String participatorType;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channel;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  private String tag;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 红包余额
   */
  @ApiModelProperty("红包余额")
  private BigDecimal balance;

  /**
   * 累计分利红包
   */
  @ApiModelProperty("累计分利红包")
  private BigDecimal accruingRedPacket;

  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  private String phone;

  /**
   * 操作类型，1：增加 2：减少
   */
  @ApiModelProperty("操作类型，1：增加 2：减少")
  private String type;

  /**
   * 明细
   */
  @ApiModelProperty("明细")
  private Set<RedPacketDetailDto> details;
}
