package com.biz.crm.cps.business.reward.redpacket.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketDetailVo;
import org.springframework.data.domain.Pageable;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/10 10:50
 */
public interface RedPacketDetailVoService {

  /**
   * 终端/经销商红包明细查看 当参数均为空时 查全部
   *
   * @param participatorCode
   * @param yearAndMonth(格式：yyyy-MM)
   * @param type 1收入 2支出
   * @return
   */
  Page<RedPacketDetailVo> findByParticipatorCodeAndCreateTimeAndType(String participatorCode, String yearAndMonth, String type, Pageable pageable);

  /**
   * 分页条件查询红包流水信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<RedPacketDetailVo> findByConditions(Pageable pageable, RedPacketDetailDto dto);
  /**
   * 创建
   * @param redPacketDetailDto
   * @return
   */
  RedPacketDetailVo create(RedPacketDetailDto redPacketDetailDto);
}
