package com.biz.crm.cps.business.reward.redpacket.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 红包余额
 * @Author: zengxingwang
 * @Date: 2021/8/5 15:28
 */
@Data
@ApiModel(value = "RedPacketBalanceVo", description = "红包余额")
public class RedPacketBalanceVo {

  /**
   * 红包余额
   */
  @ApiModelProperty("红包余额")
  private BigDecimal balance;

  /**
   * 昨日发放红包（元）
   */
  @ApiModelProperty("昨日发放红包（元）")
  private BigDecimal yesterdayAmount;

  /**
   * 昨日红包上帐（元）
   */
  @ApiModelProperty("昨日红包上帐（元）")
  private BigDecimal yesterdayKeepBooks;

  /**
   * 日平均金额
   */
  @ApiModelProperty("日平均金额")
  private BigDecimal averageAmount;

  /**
   * 统计时间（天）
   */
  @ApiModelProperty("统计时间（天）")
  private Integer statisticsDay;

  /**
   * 预计时间（天）
   */
  @ApiModelProperty("统计时间（天）")
  private Integer predictDay;

  /**
   * 指定日期发放红包金额
   */
  @ApiModelProperty("指定日期发放红包金额")
  List<RedPacketStatisticsDayVo> amountList;
}
