package com.biz.crm.cps.business.reward.redpacket.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 终端/经销商红包明细查看vo
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 15:28
 */
@Data
@ApiModel(value = "RedPacketDetailVo", description = "终端/经销商红包明细查看vo")
public class RedPacketDetailVo {

  /**
   * 红包变动流水编码
   */
  @ApiModelProperty("红包变动流水编码")
  private String code;

  /**
   * 参与者类型
   */
  @ApiModelProperty("参与者类型")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称")
  private String participatorName;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String phone;

  /**
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  private String triggerObject;

  /**
   * 开始发放时间
   */
  @ApiModelProperty("开始发放时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startReleaseTime;

  /**
   * 结束发放时间
   */
  @ApiModelProperty("结束发放时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endReleaseTime;

  /**
   * 红包id
   */
  @ApiModelProperty("红包id")
  private String redPacketId;

  /**
   * 租户编号 不用向外暴露
   */
  private String tenantCode;


  /**
   * 参与者所属机构编码
   */
  @ApiModelProperty("参与者所属机构编码")
  private String orgCode;

  /**
   * 参与者所属机构名称
   */
  @ApiModelProperty("参与者所属机构名称")
  private String orgName;
  /**
   * 参与者所属渠道
   */
  @ApiModelProperty("参与者所属渠道")
  private String channel;
  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  private String agreementCode;
  /**
   * 模版编码
   */
  @ApiModelProperty("模版编码")
  private String templateCode;
  /**
   * 协议编码
   */
  @ApiModelProperty("协议名称")
  private String agreementName;

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("政策名称")
  private String policyName;
  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  private String recordCode;
  /**
   * 变动金额
   */
  @ApiModelProperty("变动金额")
  private BigDecimal amount;

  /**
   * 红包余额
   */
  @ApiModelProperty("红包余额")
  private BigDecimal balance;
  /**
   * 时间
   */
  @ApiModelProperty("时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /**
   * 操作类型，1：增加 2：减少
   */
  @ApiModelProperty("操作类型，1：增加 2：减少")
  private String type;

  /**
   * 消费者id
   */
  @ApiModelProperty("消费者id")
  private String externalId;

  /**
   * 微信昵称
   */
  @ApiModelProperty("微信昵称")
  private String nickname;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String organization;

  /**
   * 客户所属组织
   */
  @ApiModelProperty("客户所属组织")
  private String customerOrganization;

  /**
   * 终端/经销商类型
   */
  @ApiModelProperty("终端/经销商类型")
  private String detailType;

  /**
   * 模板名称
   */
  @ApiModelProperty("模板名称")
  private String templateName;

  /**
   * 返利类型 (正向，反向)
   */
  @ApiModelProperty("返利类型 (正向，反向)")
  private String rebateType;

  /**
   * 标签
   */
  @ApiModelProperty("标签")
  private String tags;
}
