package com.biz.crm.cps.business.reward.sdk.common.enums;

/**
 * @Description:奖励类型
 * @Author: zengxingwang
 **/
public enum RewardTypeEnum {
  /**
   * 红包
   */
  REDPACKET("redpacket", "1", "红包", "1"),
  /**
   * 费用
   */
  COST("cost", "3", "费用", "3"),
  /**
   * 积分
   */
  INTEGRAL("integral", "2", "积分", "2"),
  /**
   * 赠品
   */
  GIFT("gift", "4", "赠品", "4"),;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  RewardTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

}

