package com.biz.crm.cps.business.reward.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

/**
 * @ClassName: CashRandomDto
 * @Author: yangfan
 * @Description: 定额随机金额dto
 * @Date: 2021/8/9 15:05
 * @Version: 1.0
 */

@Data
@ApiModel(value = "CashRandomDto", description = "定额随机金额dto")
public class CashRandomDto implements Serializable {
  private static final long serialVersionUID = 4502931160852585316L;

  /**
   * 占用比例
   */
  @ApiModelProperty("占用比例")
  private BigDecimal percent;

  /**
   * 金额
   */
  @ApiModelProperty("金额")
  private BigDecimal cash;

}
