package com.biz.crm.cps.business.reward.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

/**
 * @ClassName: RewardCashConditionDto
 * @Author: hecheng
 * @Description: 奖励兑付条件
 */
@Data
@ApiModel(value = "RewardCashConditionDto", description = "奖励兑付条件dto")
public class RewardCashConditionDto {


  /**
   * 提现时必传 提现金额
   */
  @ApiModelProperty(name = "提现金额", required = true)
  private BigDecimal amount;
  /**
   * 提现时必传 参与者编码 经销商/终端/消费者 编码
   */
  @ApiModelProperty(name = "参与者编码）", required = true)
  private String participatorCode;

  /**
   * 提现时必传 参与者编码 经销商/终端/消费者 名称
   */
  @ApiModelProperty(name = "参与者名称）", required = true)
  private String participatorName;

  /**
   * 提现时必传 ParticipatorTypeEnum 参与者标记（实际扫码者） 1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty(name = "参与者标记", required = true)
  private String participatorFlag;

  /**
   * 提现时必传 微信 或者第三方提现时的外部id
   */
  @ApiModelProperty(name = "openId", required = true)
  private String openId;
  /**
   * 收款人编码 （终端用户、经销商用户、消费者openid）
   */
  @ApiModelProperty(name = "收款人编码", required = true)
  private String payeeCode;

  /**
   * 收款人姓名 参与者标记为终端和经销商时 这个值由当前登录用户中获取，消费者为微信昵称
   */
  @ApiModelProperty(name = "收款人姓名", required = true)
  private String payeeName;
  /**
   * 收款人电话 参与者标记为终端和经销商时 这个值由当前登录用户中获取，消费者为微信昵称
   */
  @ApiModelProperty("收款人电话")
  private String payeePhone;

  /**
   * 兑付类型 微信，支付宝 (这里为系统默认配置值，可能会被后续替换)
   */
  @ApiModelProperty("兑付类型")
  private String cashKey;
  /**
   * 奖励流水id
   */
  @ApiModelProperty("奖励流水id")
  private String rewardId;
  /**
   * 奖励方式
   */
  @ApiModelProperty("奖励方式")
  private String rewardKey;

  /**
   * 奖励方式
   */
  @ApiModelProperty("奖励方式")
  private String rewardName;
}
