package com.biz.crm.cps.business.reward.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
/**
 * @ClassName: RewardConditionDto
 * @Author: yangfan
 * @Description: 奖励条件信息
 * @Date: 2021/8/13 15:45
 * @Version: 1.0
 */
@Data
public class RewardConditionDto implements Serializable {
  private static final long serialVersionUID = -6809276319557607168L;

  /** 传递时不设置此参数，此参数由实际扫码者查询获取
   * 得到这份奖励的参与者(分利参与者 标记）
   */
  @ApiModelProperty("得到这份奖励的参与者(分利参与者 标记）")
  private String additionalParticipatorFlag;

  /**传递时不设置此参数，此参数由实际扫码者查询获取
   * 得到这份奖励的参与者(分利参与者 中文名）
   */
  @ApiModelProperty("得到这份奖励的参与者(分利参与者 中文名）")
  private String additionalParticipatorName;

  /**传递时不设置此参数，此参数由实际扫码者查询获取
   * 得到这份奖励的参与者编码(分利参与者 中文名）
   */
  @ApiModelProperty("得到这份奖励的参与者(分利参与者编码）")
  private String additionalParticipatorCode;

  /**
   * 奖励方式标志（费用，红包，等等）
   */
  @ApiModelProperty("奖励方式标志（费用，红包，等等）")
  private String rewardMethodFlag;

  /**
   * 奖励方式名称（费用，红包，等等）
   */
  @ApiModelProperty("奖励方式名称（费用，红包，等等）")
  private String rewardMethodName;

  /**
   * 奖励条件标志(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件标志(固定额度，定额随机)")
  private String awardConditionFlag;

  /**
   * 奖励条件名称(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件名称(固定额度，定额随机)")
  private String awardConditionName;

  /**
   * 奖励数据
   * 当为 固定随机时
   * <pre>
   *   [
   *   {
   *     "cash": 10, //金额
   *     "percent": 10 //占用比例
   *   },
   *   {
   *     "cash": 20,
   *     "percent": 20
   *   },
   *   {
   *     "cash": 30,
   *     "percent": 70
   *   }
   * ]
   * </pre>
   */
  @ApiModelProperty("奖励数据")
  private String rewardData;

  /**
   * 参与者编码（实际扫码者）
   */
  @ApiModelProperty("参与者编码（实际扫码者）")
  private String actualParticipatorCode;

  /**
   * ParticipatorTypeEnum
   * 参与者标记（实际扫码者） 1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("参与者标记（实际扫码者）")
  private String actualParticipatorFlag;

  /**
   * 参与者编码（实际扫码者）
   */
  @ApiModelProperty("参与者名称（实际扫码者）")
  private String actualParticipatorName;

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("政策名称")
  private String policyName;

  /**
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  private String triggerObject;

  /**
   * 协议
   */
  @ApiModelProperty("协议")
  private String agreementCode;
  /**
   * 模版编码
   */
  @ApiModelProperty("模版编码")
  private String templateCode;
  /**
   * 机构编码
   */
  @ApiModelProperty("机构编码")
  private String orgCode;

  /**
   * 机构名称
   */
  @ApiModelProperty("机构名称")
  private String orgName;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  @TableField(value = "phone")
  private String phone;

  /**
   * 参与者所属渠道
   */
  @ApiModelProperty("参与者所属渠道")
  private String channel;

  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  private String recordCode;

  /**
   * 区分是得到这份奖励的参与者 还是实际扫码者 为了保存插入字段取值用。
   */
  @ApiModelProperty("区分标识")
  private String distinguishFlag;

  /**
   * 赠品编码
   */
  @ApiModelProperty("赠品编码")
  private String giftCode;

  /**
   * 奖项编码
   */
  @ApiModelProperty("奖项编码")
  private String rewardCode;

  /**
   * 返利类型 (正向，反向)
   *
   * @see com.biz.crm.cps.business.policy.scan.sdk.common.enums.RebateTypeEnum dictCode
   */
  @ApiModelProperty("返利类型 (正向，反向)")
  private String rebateType;


  /**
   * 传递奖励
   */
  @ApiModelProperty("传递奖励")
  private List<RewardConditionDto> rewardConditionDtos;

  /**
   * 扫码活动编码
   */
  private String actCode;

  /**
   * 扫码活动红包发放账户
   */
  private String accountCode;
}
