package com.biz.crm.cps.business.reward.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: 累计收益情况统计
 * @date 2021/8/18 上午10:54
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardReportDto", description = "累计收益情况统计")
public class RewardReportDto {

  /**
   * 模版编码
   */
  @ApiModelProperty("模版编码")
  private String templateCode;
  /**
   * 参与者code
   */
  @ApiModelProperty("参与者code")
  private String participatorCode;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  private String agreementCode;

  /**
   * 协议编码集合
   */
  @ApiModelProperty("协议编码集合")
  private List<String> agreementCodes;
  /**
   * 扫码记录code
   */
  @ApiModelProperty("扫码记录code")
  private List<String> recordCodes;
}
