package com.biz.crm.cps.business.reward.sdk.event;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 请求提现模块数据监听器
 * @author songjingen
 */
public interface RequestCashListener {

  /**
   * 通过参与者信息何时间段请求提现金额数据
   * @param participatorCode 参与者编码
   * @param participatorFlag 参与者标识
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return
   */
  BigDecimal onRequestAmountByParticipatorAndDateTime(String participatorCode, String participatorFlag, Date startTime, Date endTime);

  /**
   * 通过参与者信息何时间段请求提现次数数据
   * @param participatorCode 参与者编码
   * @param participatorFlag 参与者标识
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return
   */
  Integer onRequestCountByParticipatorAndDateTime(String participatorCode, String participatorFlag, Date startTime, Date endTime);
}
