package com.biz.crm.cps.business.reward.sdk.service;


import com.biz.crm.cps.business.reward.sdk.dto.RewardCashConditionDto;
import java.math.BigDecimal;
import java.util.List;

/**
 * 兑现服务接口
 *
 * @author hecheng
 * @date 2021/08/26
 */
public interface RewardCashVoService {

  /**
   * 提现
   * <pre>
   * 1校验参数、校验提现前置条件，余额等
   * 2扣减红包余额、生成红包流水记录
   * 3通知兑现模块，完成发放
   * amount 、participatorCode、participatorName、participatorFlag、openId 必传
   * </pre>
   */
  void cash(RewardCashConditionDto conditionDto);

  /**
   * 经销商、终端 提现
   * <pre>
   * 1校验参数、校验提现前置条件，余额等
   * 2扣减红包余额、生成红包流水记录
   * 3通知兑现模块，完成发放
   * amount 、participatorCode、participatorName、participatorFlag、openId 必传
   * </pre>
   */
  void currentUserCash(BigDecimal amount,String operatorOpenId, String caseKey);

  /**
   * 消费者 提现
   * @param amount
   * @param openId
   */
  void consumerCash(BigDecimal amount,String openId);

  /**
   * 按消费者openId查询一组扫码记录的累计获利
   * @param openId
   * @param recordCodes
   * @return
   */
  BigDecimal findByConsumerOpenIdRecordCodes(String openId,List<String> recordCodes);
}
