package com.biz.crm.cps.business.reward.sdk.service.observer;

/**
 * 奖励计算方式策略挂载观察 红包,现金，积分等模块实现该接口，让奖励模板模块知道系统中已经存在的实现
 *
 * @Author: hecheng
 */
public interface ComputeTypeMountRegister {

  /**
   * 红包计算类型中文名称 具体计算方法等实现该方法，告知红包计算的中文名（注意，具体的计算类型中，设定的该信息不能重复）
   *
   * @return
   */
  String getName();

  /**
   * 红包计算类型key 具体计算方法实现该方法，告知红包计算的英文key（注意，具体的计算类型型中，设定的该信息不能重复）
   *
   * @return
   */
  String getKey();

  /**
   * 红包计算类型flag 具体计算方法该方法，告知协议模板本政策的标识数字（注意，具体的计算类型中，设定的该信息不能重复）
   *
   * @return
   */
  String getFlag();

}
