package com.biz.crm.cps.business.reward.sdk.service.observer;

import com.biz.crm.cps.business.reward.sdk.dto.RewardCashConditionDto;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashProcessVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashRecordVo;

/**
 * RewardCashObserver 奖励兑现观察者 由 具体的奖励方式实现 比如红包模块的提现功能
 *
 * @Author: hecheng
 */
public interface RewardCashObserver {

  /**
   * 获取兑现步骤 如果用户有自定义那么这里可能会修改系统默认设置的兑付配置
   * <pre>
   *   兑现规则由触发模块内部校验 如红包提现规则由自己模块内部校验
   *   向上通知 兑现模块，校验当前用户是否满足提现前置条件
   *   这里的前置条件指是否需要 签署服务合同，认证等
   * </pre>
   */
  RewardCashProcessVo onRequestCashProcess(RewardCashConditionDto condition);

  /**
   * <pre>
   *   通知所以实现兑现功能的具体模块开始工作
   * </pre>
   */
  RewardCashRecordVo onCash(RewardCashConditionDto condition);
}
