package com.biz.crm.cps.business.reward.sdk.service.observer;

/**
 * 奖励策略挂载观察
 *   红包,现金，积分等模块实现该接口，让奖励模板模块知道系统中已经存在的实现
 * @Author: yangfan
 */
public interface RewardMountRegister {

  /**
   * 奖励类型中文名称
   * 具体红包,现金，积分等实现该方法，告知奖励模板本政策的中文名（注意，具体的奖励类型中，设定的该信息不能重复）
   * @return
   */
  String getName();

  /**
   * 奖励类型key
   * 具体政策实现该方法，告知协议模板本政策的英文key（注意，具体的奖励类型中，设定的该信息不能重复）
   * @return
   */
  String getKey();

  /**
   * 奖励类型flag
   * 具体政策实现该方法，告知协议模板本政策的标识数字（注意，具体的奖励类型中，设定的该信息不能重复）
   * @return
   */
  String getFlag();

}
