package com.biz.crm.cps.business.reward.sdk.service.observer;

import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementItemVo;
import java.util.List;

/**
 * @ClassName: RewardRelAgreementServiceObserver
 * @Author: hecheng
 * @Description: 统计协议 获利汇总观察者接口
 */
public interface RewardRelAgreementServiceObserver {


  /**
   * 当统计协议获利事件发生时，该事件被触发。一般来说，该事件用于按协议统计红包、积分、费用获利的处理场景等
   * @param participatorCode
   * @param templateCodes
   * @return
   */
  List<RewardRelAgreementItemVo> onRequestRewardRelAgreementItems(String participatorCode, List<String> templateCodes);

}
