package com.biz.crm.cps.business.reward.sdk.service.observer;

import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorItemVo;
import java.util.List;

/**
 * @ClassName: RewardRelParticipatorServiceObserver
 * @Author: hecheng
 * @Description: 参与者获取 获利汇总观察者接口
 */
public interface RewardRelParticipatorServiceObserver {

  /**
   * 当统计参与者获利事件发生时，该事件被触发。一般来说，该事件用于按参与者统计红包、积分、费用获利的处理场景等
   *
   * @param participatorCodes
   * @return
   */
  List<RewardRelParticipatorItemVo> onRequestRewardRelParticipatorItems(List<String> participatorCodes);
}
