package com.biz.crm.cps.business.reward.sdk.service.observer;

import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import java.util.List;

/**
 * @ClassName: RewardRelScanCodeServiceObserver
 * @Author: hecheng
 * @Description: 统计扫码 获利汇总观察者接口
 */
public interface RewardRelScanCodeServiceObserver {


  /**
   * 当统计扫码获利事件发生时，该事件被触发。一般来说，该事件用于按扫码统计红包、积分、费用获利的处理场景等
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  List<RewardRelScanCodeItemVo> onRequestRewardRelScanCodeItems(String participatorCode, List<String> recordCodes);

}
