package com.biz.crm.cps.business.reward.sdk.service.observer;

import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import java.util.List;

/**
 * @ClassName: RewardTypeStatisticsServiceObserver
 * @Author: hecheng
 * @Description: 奖励统计观察者接口
 */
public interface RewardTypeStatisticsServiceObserver {

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   *
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  RewardTypeStatisticsVo onRequestRewardTypeStatisticsVo(String participatorCode, List<String> recordCodes);

  /**
   * 按租户和触发动作汇总
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  RewardTypeStatisticsVo onRequestRewardTypeStatisticsVo(String tenantCode,String triggerAction);
}
