package com.biz.crm.cps.business.reward.sdk.service.strategy;

import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;

/**
 * 计算，所有红包的计算方式都要实现这个接口
 *
 * @Author: hecheng
 */
public interface RewardComputeStrategy {

  /**
   * 计算类型key 具体计算方法实现该方法，告知红包计算的英文key（注意，具体的计算类型型中，设定的该信息不能重复）
   *
   * @return
   */
  String getKey();

  /**
   * 具体的计算方式
   *
   * @param dto
   */
  ComputeCashVo calculate(RewardConditionDto dto);
}
