package com.biz.crm.cps.business.reward.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;

import java.util.List;
import lombok.Data;

/**
 * @ClassName: computeCashVo
 * @Author: yangfan
 * @Description: 计算金额vo
 * @Date: 2021/8/9 14:10
 * @Version: 1.0
 */
@Data
@ApiModel(value = "ComputeCashVo", description = "计算红包金额")
public class ComputeCashVo implements Serializable {
  private static final long serialVersionUID = 5503075230140388782L;

  /**
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  private String triggerAction;

  /**
   * 获取红包方式
   */
  @ApiModelProperty("红包方式： fixed_amount 固定额度 change_amount 定额随机")
  private String recordType;

  /**
   * 固定额度红包值
   */
  @ApiModelProperty("固定额度红包值")
  private BigDecimal recordCash;


  /**
   * 定额随机金额信息
   */
  @ApiModelProperty("随机额度红包值")
  private List<CashRandomVo> changeCashList;

}
