package com.biz.crm.cps.business.reward.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

/**
 * @ClassName: RewardStatisticsVo
 * @Author: 何成
 * @Description: 协议奖励统计
 * @Version: 1.0
 */
@Data
@ApiModel(value = "ParticipatorRewardStatisticsVo", description = "参与者奖励统计")
public class ParticipatorRewardStatisticsVo implements Serializable {
  /**
   * 参与者code
   */
  @ApiModelProperty("参与者code")
  private String participatorCode;

  /**
   * 统计金额汇总
   */
  @ApiModelProperty("统计金额汇总")
  private BigDecimal amount;

  /**
   * 余额
   */
  @ApiModelProperty("余额")
  private BigDecimal balance;

  /**
   * 今日收益
   */
  @ApiModelProperty("今日收益")
  private BigDecimal todayAmount;
}
