package com.biz.crm.cps.business.reward.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author hecheng
 * @description: 兑现步骤Vo
 * @date 2021/8/26 下午9:19
 */
@Data
@ApiModel(value = "RewardCashProcessVo", description = "兑现步骤Vo")
public class RewardCashProcessVo {

  /**
   * 兑现方式flag
   */
  @ApiModelProperty("兑现方式flag")
  private String flag;
  /**
   * 兑现方式key
   */
  @ApiModelProperty("兑现方式key")
  private String key;
  /**
   * 兑现方式name
   */
  @ApiModelProperty("兑现方式name")
  private String name;
  /**
   * 兑现方式是否需要显示的签署协议， 系统中约定任何兑现方式都需要签署协议，但是存在是否存在用户感知的签署流程
   */
  @ApiModelProperty("兑现方式是否需要显示的签署协议， 系统中约定任何兑现方式都需要签署协议，但是存在是否存在用户感知的签署流程")
  private boolean needSign;
  /**
   * 是否需要实名认证
   */
  @ApiModelProperty("是否需要实名认证")
  private boolean needVerify;
  /**
   * 申请证书状态(0：没有申请证书，1：成功申请证书, 2:身份证已被使用，请重新认证, 3：申请证书失败)
   *
   */
  @ApiModelProperty("申请证书状态(0：没有申请证书，1：成功申请证书, 2:身份证已被使用，请重新认证, 3：申请证书失败)")
  private String certStatus;
  /**
   * 实名认证 url
   */
  @ApiModelProperty("实名认证 url")
  private String verifyUrl;

  /**
   * 签署url
   */
  @ApiModelProperty("签署url")
  private String contractSignUrl;

  /**
   * 签署合同查看url
   */
  @ApiModelProperty("签署合同查看url")
  private String contractViewUrl;
}
