package com.biz.crm.cps.business.reward.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * @ClassName: RewardRelParticipatorVo
 * @Author: hecheng
 * @Description: 参与者的所有奖励信息汇总vo
 * @Version: 1.0
 */
@Data
@ApiModel(value = "RewardRelParticipatorVo", description = "参与者的所有奖励信息汇总vo")
public class RewardRelParticipatorVo {

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  private String participatorCode;

  /**
   * 每种奖励的 获利汇总
   */
  @ApiModelProperty("每种奖励的 获利汇总")
  private List<RewardTypeStatisticsVo> rewardTypeStatisticsVos;
}
