package com.biz.crm.cps.business.reward.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Set;
import lombok.Data;

/**
 * @ClassName: RewardRelScanCodeItemVo
 * @Author: hecheng
 * @Description: 每个奖励模块的扫码获利信息vo
 * @Version: 1.0
 */
@Data
@ApiModel(value = "RewardRelScanCodeItemVo", description = "每个奖励模块的扫码获利信息vo")
public class RewardRelScanCodeItemVo {

  /**
   * 扫码编码
   */
  @ApiModelProperty("扫码编码")
  private String recordCode;
  /**
   * 模版编码集合
   */
  @ApiModelProperty("模版编码")
  private List<String> templateCodes;
  /**
   * 政策名称集合
   */
  @ApiModelProperty("政策名称")
  private Set<String> policyNames;
  /**
   * 政策名称
   */
  @ApiModelProperty("政策名称")
  private String policyNameStr;
  /**
   * 协议名称
   */
  @ApiModelProperty("协议名称")
  private String agreementNames;
  /**
   *获利信息
   */
  @ApiModelProperty("获利信息")
  private RewardTypeStatisticsVo rewardStatisticsVo;
}
