package com.biz.crm.cps.business.reward.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

/**
 * @ClassName: RewardTypeStatisticsVo
 * @Author: 何成
 * @Description: 奖励类型统计 泛指 红包、费用等统计信息
 * @Version: 1.0
 */
@Data
@ApiModel(value = "RewardTypeStatisticsVo", description = "奖励类型统计")
public class RewardTypeStatisticsVo implements Serializable {
  /**
   * 奖励中文名称 红包、积分、费用
   */
  @ApiModelProperty("奖励中文名称")
  private String name;
  /**
   * 奖励唯一码
   */
  @ApiModelProperty("奖励唯一码")
  private String flag;

  /**
   * 奖励唯一码 英文
   */
  @ApiModelProperty("奖励唯一码 英文")
  private String key;

  /**
   * 统计金额汇总
   */
  @ApiModelProperty("统计金额汇总")
  private BigDecimal amount;
  /**
   * 余额
   */
  @ApiModelProperty("余额")
  private BigDecimal balance;

  /**
   * 今日收益
   */
  @ApiModelProperty("今日收益")
  private BigDecimal todayAmount;
}
