package com.biz.crm.cps.business.reward.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

/**
 * @ClassName: ScanCodeRewardStatisticsVo
 * @Author: 何成
 * @Description: 扫码奖励统计
 * @Version: 1.0
 */
@Data
@ApiModel(value = "ScanCodeRewardStatisticsVo", description = "扫码奖励统计")
public class ScanCodeRewardStatisticsVo implements Serializable {

  /**
   * 扫码code
   */
  @ApiModelProperty("扫码code")
  private String recordCode;

  /**
   * 模版编码
   */
  @ApiModelProperty("模版编码")
  private String templateCode;

  /**
   * 政策name
   */
  @ApiModelProperty("政策name")
  private String policyName;
  /**
   * 统计金额汇总
   */
  @ApiModelProperty("统计金额汇总")
  private BigDecimal amount;

}
