/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.local.service.observer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.PolicyObserverDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyMountObserver;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyPojoObserver;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyRewardDataVo;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeEvent;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeExpression;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeRange;
import com.biz.crm.cps.business.policy.scan.local.service.ScanCodeConfigurationService;
import com.biz.crm.cps.business.policy.scan.sdk.common.enums.ScanCodeActionEnum;
import com.biz.crm.cps.business.policy.scan.sdk.vo.ScanCodeConfigurationVo;
import com.biz.crm.cps.business.policy.scan.sdk.vo.ScanCodeExpresionVo;
import com.biz.crm.cps.business.policy.scan.sdk.vo.ScanCodeParticipatorVo;
import com.biz.crm.cps.business.policy.scan.sdk.vo.ScanCodePolicyVo;
import com.biz.crm.cps.business.policy.sdk.dto.PolicyRewardConditionDto;
import com.biz.crm.cps.business.policy.sdk.service.observer.PolicyRewardServiceObserver;
import com.biz.crm.cps.business.product.sdk.dto.MaterialDimensionDto;
import com.biz.crm.cps.business.product.sdk.dto.ProductDimensionDto;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.service.ProductVoService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ScanCodePolicyServiceObserverImpl")
public class ScanCodePolicyServiceObserverImpl
implements AgreementPolicyServiceObserver {
    @Autowired
    private ScanCodeConfigurationService scanCodeConfigurationService;
    @Autowired(required=false)
    private List<PolicyRewardServiceObserver> policyRewardServiceObservers;
    @Autowired
    @Qualifier(value="ScanCodePolicyPojoObserverImpl")
    private AgreementPolicyPojoObserver agreementPolicyPojoObserver;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private MaterialVoService materialVoService;
    @Autowired
    @Qualifier(value="ScanCodePolicyMountObserverImpl")
    private AgreementPolicyMountObserver agreementPolicyMountObserver;

    public void save(AgreementPolicyDto agreementPolicyDto) {
        this.scanCodeConfigurationService.create(agreementPolicyDto);
    }

    public AgreementPolicyVo findDetailsByTemplateCode(String templateCode) {
        List<ScanCodeConfiguration> scanCodeConfigurations = this.scanCodeConfigurationService.findDetailsByTemplateCode(templateCode);
        if (CollectionUtils.isEmpty(scanCodeConfigurations)) {
            return null;
        }
        ScanCodePolicyVo scanCodePolicyVo = new ScanCodePolicyVo();
        LinkedList scanCodeConfigurationVos = Lists.newLinkedList();
        for (ScanCodeConfiguration scanCodeConfiguration : scanCodeConfigurations) {
            ScanCodeConfigurationVo scanCodeConfigurationVo = this.entityToVo(scanCodeConfiguration);
            scanCodeConfigurationVos.add(scanCodeConfigurationVo);
        }
        scanCodePolicyVo.setScanCodeConfigurationVos((Collection)scanCodeConfigurationVos);
        scanCodePolicyVo.setPolicyKey(this.agreementPolicyMountObserver.getKey());
        scanCodePolicyVo.setTemplateCode(templateCode);
        return scanCodePolicyVo;
    }

    private ScanCodeConfigurationVo entityToVo(ScanCodeConfiguration scanCodeConfiguration) {
        ScanCodeConfigurationVo vo = (ScanCodeConfigurationVo)this.nebulaToolkitService.copyObjectByBlankList((Object)scanCodeConfiguration, ScanCodeConfigurationVo.class, HashSet.class, LinkedList.class, new String[0]);
        String separator = "@";
        LinkedHashSet scanCodeParticipatorVos = Sets.newLinkedHashSet();
        Set<ScanCodeEvent> scanCodeEvents = scanCodeConfiguration.getScanCodeEvents();
        Map<String, List<ScanCodeEvent>> participatorMap = scanCodeEvents.stream().collect(Collectors.groupingBy(scanCodeEvent -> StringUtils.join((Object[])new String[]{scanCodeEvent.getParticipatorFlag(), separator, scanCodeEvent.getParticipatorName()})));
        for (Map.Entry<String, List<ScanCodeEvent>> entry : participatorMap.entrySet()) {
            String participator = entry.getKey();
            String[] split = participator.split(separator);
            ScanCodeParticipatorVo scanCodeParticipatorVo = new ScanCodeParticipatorVo();
            scanCodeParticipatorVo.setParticipatorFlag(split[0]);
            scanCodeParticipatorVo.setParticipatorName(split[1]);
            Set<ScanCodeExpresionVo> scanCodeExpresionVos = this.getScanCodeExpresionVos(entry.getValue());
            scanCodeParticipatorVo.setScanCodeExpressions(scanCodeExpresionVos);
            scanCodeParticipatorVos.add(scanCodeParticipatorVo);
        }
        vo.setScanCodeParticipators((Set)scanCodeParticipatorVos);
        return vo;
    }

    private Set<ScanCodeExpresionVo> getScanCodeExpresionVos(List<ScanCodeEvent> value) {
        LinkedHashSet scanCodeExpresionVos = Sets.newLinkedHashSet();
        for (ScanCodeEvent scanCodeEvent : value) {
            Set<ScanCodeExpression> scanCodeExpressions = scanCodeEvent.getScanCodeExpressions();
            Map<Boolean, List<ScanCodeExpression>> expressionIdMap = scanCodeExpressions.stream().collect(Collectors.partitioningBy(scanCodeExpression -> StringUtils.isNotBlank((CharSequence)scanCodeExpression.getExpressionId())));
            List<ScanCodeExpression> outerLayerExpressions = expressionIdMap.get(false);
            List<ScanCodeExpression> transferExpressions = expressionIdMap.get(true);
            Map<String, List<ScanCodeExpression>> expressionIdTransferMap = transferExpressions.stream().collect(Collectors.groupingBy(ScanCodeExpression::getExpressionId));
            for (ScanCodeExpression outerLayerExpression : outerLayerExpressions) {
                ScanCodeExpresionVo scanCodeExpresionVo = (ScanCodeExpresionVo)this.nebulaToolkitService.copyObjectByBlankList((Object)outerLayerExpression, ScanCodeExpresionVo.class, HashSet.class, LinkedList.class, new String[0]);
                scanCodeExpresionVo.setBarCodeTypeFlag(scanCodeEvent.getBarCodeTypeFlag());
                scanCodeExpresionVo.setBarCodeTypeName(scanCodeEvent.getBarCodeTypeName());
                List<ScanCodeExpresionVo> transferScanCodeExpresionVos = this.getScanCodeExpresionVos(scanCodeEvent, expressionIdTransferMap, outerLayerExpression);
                if (!CollectionUtils.isEmpty(transferScanCodeExpresionVos)) {
                    scanCodeExpresionVo.setScanCodeExpressions((Set)Sets.newLinkedHashSet(transferScanCodeExpresionVos));
                }
                scanCodeExpresionVos.add(scanCodeExpresionVo);
            }
        }
        return scanCodeExpresionVos;
    }

    private List<ScanCodeExpresionVo> getScanCodeExpresionVos(ScanCodeEvent scanCodeEvent, Map<String, List<ScanCodeExpression>> expressionIdTransferMap, ScanCodeExpression outerLayerExpression) {
        List<ScanCodeExpression> expressionIdTransferExpressions = expressionIdTransferMap.get(outerLayerExpression.getId());
        if (CollectionUtils.isEmpty(expressionIdTransferExpressions)) {
            return null;
        }
        List transferScanCodeExpresionVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(expressionIdTransferExpressions, ScanCodeExpression.class, ScanCodeExpresionVo.class, HashSet.class, LinkedList.class, new String[0]);
        for (ScanCodeExpresionVo transferScanCodeExpresionVo : transferScanCodeExpresionVos) {
            transferScanCodeExpresionVo.setBarCodeTypeFlag(scanCodeEvent.getBarCodeTypeFlag());
            transferScanCodeExpresionVo.setBarCodeTypeName(scanCodeEvent.getBarCodeTypeName());
        }
        return transferScanCodeExpresionVos;
    }

    public void processScanCode(PolicyObserverDto policyObserverDto) {
        List<PolicyRewardConditionDto> policyRewardConditionDtos = this.findPolicyConfig(policyObserverDto);
        String participatorCode = policyObserverDto.getParticipatorCode();
        String participatorType = policyObserverDto.getParticipatorType();
        String triggerAction = this.judgeTriggerAction(policyObserverDto);
        String triggerObject = policyObserverDto.getProductCode();
        String recordCode = policyObserverDto.getRecordCode();
        this.setCommonProperty(policyRewardConditionDtos, participatorCode, participatorType, triggerAction, triggerObject, recordCode);
        this.callRewardObservers(policyRewardConditionDtos);
    }

    private String judgeTriggerAction(PolicyObserverDto policyObserverDto) {
        String triggerAction = "\u7cfb\u7edf\u5185\u65e0\u6709\u6548\u52a8\u4f5c";
        String barCodeType = policyObserverDto.getBarCodeType();
        if (BarCodeTypeEnum.BOX.getFlag().equals(barCodeType)) {
            triggerAction = ScanCodeActionEnum.BOX_CODE.getDesc();
        } else if (BarCodeTypeEnum.BOTTLE.getFlag().equals(barCodeType)) {
            triggerAction = ScanCodeActionEnum.CASE_CODE.getDesc();
        } else if (BarCodeTypeEnum.COVER_CODE.getFlag().equals(barCodeType)) {
            triggerAction = ScanCodeActionEnum.COVER_CODE.getDesc();
        }
        return triggerAction;
    }

    private void setCommonProperty(List<PolicyRewardConditionDto> policyRewardConditionDtos, String participatorCode, String participatorType, String triggerAction, String triggerObject, String recordCode) {
        for (PolicyRewardConditionDto rewardConditionDto : policyRewardConditionDtos) {
            rewardConditionDto.setActualParticipatorCode(participatorCode);
            rewardConditionDto.setActualParticipatorFlag(participatorType);
            rewardConditionDto.setTriggerAction(triggerAction);
            rewardConditionDto.setTriggerObject(triggerObject);
            rewardConditionDto.setRecordCode(recordCode);
            List conditionDtos = rewardConditionDto.getPolicyRewardConditionDtos();
            if (CollectionUtils.isEmpty((Collection)conditionDtos)) continue;
            this.setCommonProperty(conditionDtos, participatorCode, participatorType, triggerAction, triggerObject, recordCode);
        }
    }

    public void save(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.getJSONArray(this.agreementPolicyMountObserver.getKey());
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return;
        }
        for (Object o : jsonArray) {
            JSONObject json = JsonUtils.toJSONObject((Object)o.toString());
            AgreementPolicyDto deserialize = this.agreementPolicyPojoObserver.deserialize(json);
            deserialize.setTemplateCode(jsonObject.getString("templateCode"));
            this.save(deserialize);
        }
    }

    public List<PolicyRewardDataVo> findPolicyRewardData(Set<String> templateCodeSet, String usertype) {
        LinkedList policyRewardDataVos = Lists.newLinkedList();
        List<ScanCodeConfiguration> scanCodeConfigurations = this.scanCodeConfigurationService.findDetailsByTemplateCodes(templateCodeSet);
        for (ScanCodeConfiguration scanCodeConfiguration : scanCodeConfigurations) {
            Set<ScanCodeRange> scanCodeRanges = scanCodeConfiguration.getScanCodeRanges();
            Set<ScanCodeEvent> scanCodeEvents = scanCodeConfiguration.getScanCodeEvents();
            for (ScanCodeEvent scanCodeEvent : scanCodeEvents) {
                Set<ScanCodeExpression> scanCodeExpressions;
                Map<Boolean, List<ScanCodeExpression>> booleanMap;
                List<ScanCodeExpression> expressionList;
                String participatorFlag = scanCodeEvent.getParticipatorFlag();
                if (!participatorFlag.equals(usertype) || CollectionUtils.isEmpty(expressionList = (booleanMap = (scanCodeExpressions = scanCodeEvent.getScanCodeExpressions()).stream().collect(Collectors.partitioningBy(exp -> StringUtils.isNotBlank((CharSequence)exp.getExpressionId())))).get(false))) continue;
                for (ScanCodeExpression expression : expressionList) {
                    String barCodeTypeName = scanCodeEvent.getBarCodeTypeName();
                    String awardConditionName = expression.getAwardConditionName();
                    String rewardMethodName = expression.getRewardMethodName();
                    String condition = StringUtils.join((Object[])new String[]{"\u6bcf", barCodeTypeName, awardConditionName, rewardMethodName});
                    String rewardData = expression.getRewardData();
                    if (CollectionUtils.isEmpty(scanCodeRanges)) {
                        PolicyRewardDataVo policyRewardDataVo = new PolicyRewardDataVo();
                        policyRewardDataVo.setSpecialName(scanCodeConfiguration.getDimensionName());
                        policyRewardDataVo.setCondition(condition);
                        policyRewardDataVo.setRewardData(rewardData);
                        policyRewardDataVos.add(policyRewardDataVo);
                        continue;
                    }
                    for (ScanCodeRange scanCodeRange : scanCodeRanges) {
                        PolicyRewardDataVo policyRewardDataVo = new PolicyRewardDataVo();
                        policyRewardDataVo.setSpecialName(scanCodeRange.getSpecialName());
                        policyRewardDataVo.setCondition(condition);
                        policyRewardDataVo.setRewardData(rewardData);
                        policyRewardDataVos.add(policyRewardDataVo);
                    }
                }
            }
        }
        return policyRewardDataVos;
    }

    private List<PolicyRewardConditionDto> findPolicyConfig(PolicyObserverDto policyObserverDto) {
        Set templateCodes = policyObserverDto.getTemplateCodes();
        List<ScanCodeConfiguration> scanCodeConfigurations = this.scanCodeConfigurationService.findDetailsByTemplateCodes(templateCodes);
        LinkedList<PolicyRewardConditionDto> policyRewardConditionDtos = new LinkedList<PolicyRewardConditionDto>();
        for (ScanCodeConfiguration scanCodeConfiguration : scanCodeConfigurations) {
            MaterialDimensionDto materialDimensionDto;
            String dimensionFlag = scanCodeConfiguration.getDimensionFlag();
            Set<ScanCodeRange> scanCodeRanges = scanCodeConfiguration.getScanCodeRanges();
            boolean matchRange = this.matchRange(scanCodeRanges, materialDimensionDto = policyObserverDto.getMaterialDimensionDto(), dimensionFlag);
            if (!matchRange) continue;
            List<PolicyRewardConditionDto> conditionDtos = this.filterRewardConditions(policyObserverDto, scanCodeConfiguration);
            policyRewardConditionDtos.addAll(conditionDtos);
        }
        return policyRewardConditionDtos;
    }

    private List<PolicyRewardConditionDto> filterRewardConditions(PolicyObserverDto policyObserverDto, ScanCodeConfiguration scanCodeConfiguration) {
        Set<ScanCodeEvent> scanCodeEvents = scanCodeConfiguration.getScanCodeEvents();
        String templateCode = scanCodeConfiguration.getTemplateCode();
        if (CollectionUtils.isEmpty(scanCodeEvents)) {
            return Lists.newLinkedList();
        }
        LinkedList<PolicyRewardConditionDto> policyRewardConditionDtos = new LinkedList<PolicyRewardConditionDto>();
        for (ScanCodeEvent scanCodeEvent : scanCodeEvents) {
            Set<ScanCodeExpression> scanCodeExpressions;
            Map<Boolean, List<ScanCodeExpression>> booleanMap;
            List<ScanCodeExpression> expressionList;
            String barCodeTypeFlag = scanCodeEvent.getBarCodeTypeFlag();
            String participatorFlag = scanCodeEvent.getParticipatorFlag();
            String participatorType = policyObserverDto.getParticipatorType();
            String barCodeType = policyObserverDto.getBarCodeType();
            if (!barCodeTypeFlag.equals(barCodeType) || !participatorFlag.equals(participatorType) || CollectionUtils.isEmpty(expressionList = (booleanMap = (scanCodeExpressions = scanCodeEvent.getScanCodeExpressions()).stream().collect(Collectors.partitioningBy(exp -> StringUtils.isNotBlank((CharSequence)exp.getExpressionId())))).get(false))) continue;
            List<ScanCodeExpression> transferList = booleanMap.get(true);
            Map<String, List<ScanCodeExpression>> expressionIdMap = transferList.stream().collect(Collectors.groupingBy(ScanCodeExpression::getExpressionId));
            for (ScanCodeExpression scanCodeExpression : expressionList) {
                PolicyRewardConditionDto outerLayerDto = this.transform(scanCodeExpression);
                List<ScanCodeExpression> transferScanCodeExpression = expressionIdMap.get(scanCodeExpression.getId());
                if (!CollectionUtils.isEmpty(transferScanCodeExpression)) {
                    List<PolicyRewardConditionDto> transferDtos = this.transformList(transferScanCodeExpression);
                    transferDtos.forEach(transferDto -> transferDto.setAgreementCode(templateCode));
                    outerLayerDto.setPolicyRewardConditionDtos(transferDtos);
                }
                outerLayerDto.setAgreementCode(templateCode);
                policyRewardConditionDtos.add(outerLayerDto);
            }
        }
        return policyRewardConditionDtos;
    }

    private List<PolicyRewardConditionDto> transformList(List<ScanCodeExpression> transferScanCodeExpression) {
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(transferScanCodeExpression, ScanCodeExpression.class, PolicyRewardConditionDto.class, HashSet.class, LinkedList.class, new String[0]);
        return list;
    }

    private PolicyRewardConditionDto transform(ScanCodeExpression scanCodeExpression) {
        return (PolicyRewardConditionDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeExpression, PolicyRewardConditionDto.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private boolean matchRange(Set<ScanCodeRange> scanCodeRanges, ProductDimensionDto productDimensionDto, String dimensionFlag) {
        if (CollectionUtils.isEmpty(scanCodeRanges)) {
            return true;
        }
        String specialCode = this.findSpecialCodeByDimension(dimensionFlag, productDimensionDto);
        for (ScanCodeRange scanCodeRange : scanCodeRanges) {
            if (!StringUtils.isNotBlank((CharSequence)specialCode) || !specialCode.equals(scanCodeRange.getSpecialCode())) continue;
            return true;
        }
        return false;
    }

    private boolean matchRange(Set<ScanCodeRange> scanCodeRanges, MaterialDimensionDto materialDimensionDto, String dimensionFlag) {
        if (CollectionUtils.isEmpty(scanCodeRanges)) {
            return true;
        }
        List<String> specialCodes = this.findSpecialCodeByDimension(dimensionFlag, materialDimensionDto);
        for (ScanCodeRange scanCodeRange : scanCodeRanges) {
            if (CollectionUtils.isEmpty(specialCodes) || !specialCodes.contains("DIMENSION_ALL") && !specialCodes.contains(scanCodeRange.getSpecialCode())) continue;
            return true;
        }
        return false;
    }

    private String findSpecialCodeByDimension(String dimensionFlag, ProductDimensionDto productDimensionDto) {
        return this.productVoService.getDimensionCode(productDimensionDto, dimensionFlag);
    }

    private List<String> findSpecialCodeByDimension(String dimensionFlag, MaterialDimensionDto materialDimensionDto) {
        return this.materialVoService.findDimensionCodes(materialDimensionDto, dimensionFlag);
    }

    private void callRewardObservers(List<PolicyRewardConditionDto> policyRewardConditionDtos) {
        if (CollectionUtils.isEmpty(this.policyRewardServiceObservers)) {
            return;
        }
        for (PolicyRewardServiceObserver rewardServiceObserver : this.policyRewardServiceObservers) {
            rewardServiceObserver.createRewardRecord(policyRewardConditionDtos);
        }
    }
}

