/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.local.service.internal;

import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeRange;
import com.biz.crm.cps.business.policy.scan.local.repository.ScanCodeRangeRepository;
import com.biz.crm.cps.business.policy.scan.local.service.ScanCodeRangeService;
import com.biz.crm.cps.business.product.local.service.MaterialGroupService;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeRangeServiceImpl
implements ScanCodeRangeService {
    @Autowired
    private ScanCodeRangeRepository scanCodeRangeRepository;
    @Autowired
    private MaterialGroupService materialGroupService;
    @Autowired
    private MaterialVoService materialVoService;

    @Override
    @Transactional
    public void create(ScanCodeConfiguration current) {
        Validate.notNull((Object)((Object)current), (String)"\u626b\u7801\u914d\u7f6e\u4fe1\u606f\u672a\u4f20", (Object[])new Object[0]);
        String dimensionFlag = current.getDimensionFlag();
        ArrayList dimensionCodes = Lists.newArrayList();
        if ("DIMENSION_ALL".equals(dimensionFlag)) {
            return;
        }
        Set<ScanCodeRange> scanCodeRanges = current.getScanCodeRanges();
        Validate.isTrue((!CollectionUtils.isEmpty(scanCodeRanges) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u914d\u7f6e\u4ea7\u54c1\u8303\u56f4", (Object[])new Object[0]);
        ArrayList<String> materialGroupCodes = new ArrayList<String>();
        for (ScanCodeRange range : scanCodeRanges) {
            range.setConfigurationId(current.getId());
            dimensionCodes.add(range.getSpecialCode());
            this.createValidation(range);
            if (!"materialGroup".equals(dimensionFlag)) continue;
            materialGroupCodes.add(range.getSpecialCode());
        }
        this.scanCodeRangeRepository.saveBatch(scanCodeRanges);
        CompletableFuture.runAsync(() -> this.materialVoService.sync(dimensionCodes, dimensionFlag));
    }

    private void createValidation(ScanCodeRange entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getConfigurationId(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u914d\u7f6e\u884cID \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getSpecialCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7279\u5f81\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getSpecialName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7279\u5f81\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getSpecialCode() == null || entity.getSpecialCode().length() < 32 ? 1 : 0) != 0, (String)"\u7279\u5f81\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getSpecialName() == null || entity.getSpecialName().length() < 255 ? 1 : 0) != 0, (String)"\u7279\u5f81\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

