/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.local.service.observer;

import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementScanCodePolicyServiceObserver;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeRange;
import com.biz.crm.cps.business.policy.scan.local.repository.ScanCodeConfigurationRepository;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AgreementScanCodePolicyServiceObserverImpl
implements AgreementScanCodePolicyServiceObserver {
    @Autowired
    private ScanCodeConfigurationRepository scanCodeConfigurationRepository;
    @Autowired
    private MaterialVoService materialVoService;

    public List<String> findProductLevelCode(String templateCode) {
        List<ScanCodeConfiguration> list = this.scanCodeConfigurationRepository.findDetailsByTemplateCode(templateCode, TenantUtils.getTenantCode());
        ArrayList codes = Lists.newArrayList();
        String dimensionFlag = "";
        if (!CollectionUtils.isEmpty(list)) {
            for (ScanCodeConfiguration configuration : list) {
                dimensionFlag = configuration.getDimensionFlag();
                for (ScanCodeRange range : configuration.getScanCodeRanges()) {
                    codes.add(range.getSpecialCode());
                }
            }
        }
        List productLevelCodes = this.materialVoService.findMaterialProductCodesByDimensionCodesAndDimensionType((List)codes, dimensionFlag);
        return productLevelCodes;
    }
}

