/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.sdk.common.enums;

import com.biz.crm.cps.external.mdm.sdk.service.DictMdmService;
import com.biz.crm.cps.external.mdm.sdk.service.UnionFuncEnumApi;
import com.biz.crm.cps.external.mdm.sdk.service.UnionMdmDictEnumApi;
import com.biz.crm.cps.external.mdm.sdk.vo.DictVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public enum ScanCodeActionEnum implements UnionMdmDictEnumApi
{
    BOX_CODE("boxCode", "boxCode", "\u626b\u7bb1\u7801", "3"),
    COVER_CODE("coverCode", "coverCode", "\u626b\u76d6\u5185\u7801", "4"),
    CASE_CODE("caseCode", "caseCode", "\u626b\u76d2\u7801", "5");

    private String key;
    private String dictCode;
    private String value;
    private String order;

    private ScanCodeActionEnum(String key, String dictCode, String value, String order) {
        this.key = key;
        this.dictCode = dictCode;
        this.order = order;
        this.value = value;
    }

    public static String getDictTypeCode() {
        return "scanCodeActionEnum";
    }

    public static Collection<DictVo> findFromSelf() {
        ScanCodeActionEnum[] values = ScanCodeActionEnum.values();
        LinkedList list = Lists.newLinkedList();
        for (ScanCodeActionEnum value : values) {
            DictVo vo = new DictVo();
            vo.setDictCode(value.getDictCode());
            vo.setDictValue(value.getValue());
            vo.setDictSort(Integer.valueOf(value.getOrder()));
            list.add(vo);
        }
        return list;
    }

    public static Collection<DictVo> findFromDictMdm(DictMdmService dictMdmService) {
        if (Objects.isNull(dictMdmService)) {
            return Lists.newLinkedList();
        }
        return dictMdmService.findByTypeCode(ScanCodeActionEnum.getDictTypeCode());
    }

    public static Collection<DictVo> union(DictMdmService dictMdmService, UnionFuncEnumApi<DictVo> enumFuncApi) {
        Collection<DictVo> self = ScanCodeActionEnum.findFromSelf();
        LinkedList fromDictMdm = ScanCodeActionEnum.findFromDictMdm(dictMdmService);
        if (CollectionUtils.isEmpty(fromDictMdm)) {
            fromDictMdm = Lists.newLinkedList();
        }
        Collection union = Objects.nonNull(enumFuncApi) ? enumFuncApi.union(self, (Collection)fromDictMdm) : CollectionUtils.union(self, (Iterable)fromDictMdm);
        return union;
    }

    public String getKey() {
        return this.key;
    }

    public String getDictCode() {
        return this.dictCode;
    }

    public String getValue() {
        return this.value;
    }

    public String getOrder() {
        return this.order;
    }
}

